/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcBlockPublicAccessExclusion;
import software.amazon.awssdk.services.ec2.model.VpcBlockPublicAccessExclusionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcBlockPublicAccessExclusionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcBlockPublicAccessExclusionsResponse> {
    private static final SdkField<List<VpcBlockPublicAccessExclusion>> VPC_BLOCK_PUBLIC_ACCESS_EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcBlockPublicAccessExclusions").getter(DescribeVpcBlockPublicAccessExclusionsResponse.getter(DescribeVpcBlockPublicAccessExclusionsResponse::vpcBlockPublicAccessExclusions)).setter(DescribeVpcBlockPublicAccessExclusionsResponse.setter(Builder::vpcBlockPublicAccessExclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcBlockPublicAccessExclusionSet").unmarshallLocationName("vpcBlockPublicAccessExclusionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcBlockPublicAccessExclusion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVpcBlockPublicAccessExclusionsResponse.getter(DescribeVpcBlockPublicAccessExclusionsResponse::nextToken)).setter(DescribeVpcBlockPublicAccessExclusionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_BLOCK_PUBLIC_ACCESS_EXCLUSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVpcBlockPublicAccessExclusionsResponse.memberNameToFieldInitializer();
    private final List<VpcBlockPublicAccessExclusion> vpcBlockPublicAccessExclusions;
    private final String nextToken;

    private DescribeVpcBlockPublicAccessExclusionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcBlockPublicAccessExclusions = builder.vpcBlockPublicAccessExclusions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpcBlockPublicAccessExclusions() {
        return this.vpcBlockPublicAccessExclusions != null && !(this.vpcBlockPublicAccessExclusions instanceof SdkAutoConstructList);
    }

    public final List<VpcBlockPublicAccessExclusion> vpcBlockPublicAccessExclusions() {
        return this.vpcBlockPublicAccessExclusions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcBlockPublicAccessExclusions() ? this.vpcBlockPublicAccessExclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcBlockPublicAccessExclusionsResponse)) {
            return false;
        }
        DescribeVpcBlockPublicAccessExclusionsResponse other = (DescribeVpcBlockPublicAccessExclusionsResponse)((Object)obj);
        return this.hasVpcBlockPublicAccessExclusions() == other.hasVpcBlockPublicAccessExclusions() && Objects.equals(this.vpcBlockPublicAccessExclusions(), other.vpcBlockPublicAccessExclusions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcBlockPublicAccessExclusionsResponse").add("VpcBlockPublicAccessExclusions", this.hasVpcBlockPublicAccessExclusions() ? this.vpcBlockPublicAccessExclusions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcBlockPublicAccessExclusions": {
                return Optional.ofNullable(clazz.cast(this.vpcBlockPublicAccessExclusions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcBlockPublicAccessExclusionSet", VPC_BLOCK_PUBLIC_ACCESS_EXCLUSIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcBlockPublicAccessExclusionsResponse, T> g) {
        return obj -> g.apply((DescribeVpcBlockPublicAccessExclusionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpcBlockPublicAccessExclusion> vpcBlockPublicAccessExclusions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcBlockPublicAccessExclusionsResponse model) {
            super(model);
            this.vpcBlockPublicAccessExclusions(model.vpcBlockPublicAccessExclusions);
            this.nextToken(model.nextToken);
        }

        public final List<VpcBlockPublicAccessExclusion.Builder> getVpcBlockPublicAccessExclusions() {
            List<VpcBlockPublicAccessExclusion.Builder> result = VpcBlockPublicAccessExclusionListCopier.copyToBuilder(this.vpcBlockPublicAccessExclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcBlockPublicAccessExclusions(Collection<VpcBlockPublicAccessExclusion.BuilderImpl> vpcBlockPublicAccessExclusions) {
            this.vpcBlockPublicAccessExclusions = VpcBlockPublicAccessExclusionListCopier.copyFromBuilder(vpcBlockPublicAccessExclusions);
        }

        @Override
        public final Builder vpcBlockPublicAccessExclusions(Collection<VpcBlockPublicAccessExclusion> vpcBlockPublicAccessExclusions) {
            this.vpcBlockPublicAccessExclusions = VpcBlockPublicAccessExclusionListCopier.copy(vpcBlockPublicAccessExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcBlockPublicAccessExclusions(VpcBlockPublicAccessExclusion ... vpcBlockPublicAccessExclusions) {
            this.vpcBlockPublicAccessExclusions(Arrays.asList(vpcBlockPublicAccessExclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcBlockPublicAccessExclusions(Consumer<VpcBlockPublicAccessExclusion.Builder> ... vpcBlockPublicAccessExclusions) {
            this.vpcBlockPublicAccessExclusions(Stream.of(vpcBlockPublicAccessExclusions).map(c -> (VpcBlockPublicAccessExclusion)((VpcBlockPublicAccessExclusion.Builder)VpcBlockPublicAccessExclusion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVpcBlockPublicAccessExclusionsResponse build() {
            return new DescribeVpcBlockPublicAccessExclusionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcBlockPublicAccessExclusionsResponse> {
        public Builder vpcBlockPublicAccessExclusions(Collection<VpcBlockPublicAccessExclusion> var1);

        public Builder vpcBlockPublicAccessExclusions(VpcBlockPublicAccessExclusion ... var1);

        public Builder vpcBlockPublicAccessExclusions(Consumer<VpcBlockPublicAccessExclusion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

