/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auth;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.auth.UserSubjectImpl;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.http.XFFResolver;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class UserInjector {
    protected final Logger log = LogManager.getLogger(UserInjector.class);
    private final ThreadPool threadPool;
    private final AuditLog auditLog;
    private final XFFResolver xffResolver;
    private final Boolean injectUserEnabled;

    public UserInjector(Settings settings, ThreadPool threadPool, AuditLog auditLog, XFFResolver xffResolver) {
        this.threadPool = threadPool;
        this.auditLog = auditLog;
        this.xffResolver = xffResolver;
        this.injectUserEnabled = settings.getAsBoolean("plugins.security.unsupported.inject_user.enabled", Boolean.valueOf(false));
    }

    public Result getInjectedUser() {
        if (!this.injectUserEnabled.booleanValue()) {
            return null;
        }
        String injectedUserString = (String)this.threadPool.getThreadContext().getTransient("injected_user");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Injected user string: {}", (Object)injectedUserString);
        }
        if (Strings.isNullOrEmpty((String)injectedUserString)) {
            return null;
        }
        String[] parts = injectedUserString.split("\\|");
        if (parts.length == 0) {
            this.log.error("User string malformed, could not extract parts. User string was '{}.' User injection failed.", (Object)injectedUserString);
            return null;
        }
        String userName = parts[0];
        if (Strings.isNullOrEmpty((String)userName)) {
            this.log.error("Username must not be null, user string was '{}.' User injection failed.", (Object)injectedUserString);
            return null;
        }
        ImmutableSet backendRoles = ImmutableSet.of();
        if (parts.length > 1 && !Strings.isNullOrEmpty((String)parts[1]) && parts[1].length() > 0) {
            backendRoles = ImmutableSet.copyOf(Arrays.asList(parts[1].split(",")));
        }
        ImmutableMap<String, String> customAttributes = ImmutableMap.of();
        if (parts.length > 3 && !Strings.isNullOrEmpty((String)parts[3]) && (customAttributes = this.mapFromArray(parts[3].split(","))) == null) {
            this.log.error("Could not parse custom attributes {}, user injection failed.", (Object)parts[3]);
            return null;
        }
        String requestedTenant = null;
        if (parts.length > 4 && !Strings.isNullOrEmpty((String)parts[4])) {
            requestedTenant = parts[4];
        }
        TransportAddress transportAddress = null;
        if (parts.length > 2 && !Strings.isNullOrEmpty((String)parts[2])) {
            try {
                transportAddress = this.parseTransportAddress(parts[2]);
            }
            catch (IllegalArgumentException | UnknownHostException e) {
                this.log.error("Cannot parse remote IP or port: {}, user injection failed.", (Object)parts[2], (Object)e);
                return null;
            }
        }
        User injectedUser = new User(userName, (ImmutableSet<String>)backendRoles, (ImmutableSet<String>)ImmutableSet.of(), requestedTenant, customAttributes, true);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Injected user object:{} ", (Object)injectedUser.toString());
        }
        return new Result(injectedUser, transportAddress);
    }

    public TransportAddress parseTransportAddress(String addr) throws UnknownHostException, IllegalArgumentException {
        int lastColonIndex = addr.lastIndexOf(58);
        if (lastColonIndex == -1) {
            throw new IllegalArgumentException("Remote address must have format ip:port");
        }
        String ip = addr.substring(0, lastColonIndex);
        String portString = addr.substring(lastColonIndex + 1);
        InetAddress iAdress = InetAddress.getByName(ip);
        int port = Integer.parseInt(portString);
        return new TransportAddress(iAdress, port);
    }

    boolean injectUser(SecurityRequestChannel request) {
        Result injectedUser = this.getInjectedUser();
        if (injectedUser == null) {
            return false;
        }
        if (injectedUser.getTransportAddress() != null) {
            this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)injectedUser.getTransportAddress());
        } else {
            this.threadPool.getThreadContext().putTransient("_opendistro_security_remote_address", (Object)this.xffResolver.resolve(request));
        }
        this.threadPool.getThreadContext().putTransient("_opendistro_security_user", (Object)injectedUser.getUser());
        this.threadPool.getThreadContext().putPersistent("_opendistro_security_authenticated_user", (Object)new UserSubjectImpl(this.threadPool, injectedUser.getUser()));
        this.auditLog.logSucceededLogin(injectedUser.getUser().getName(), true, null, request);
        return true;
    }

    protected ImmutableMap<String, String> mapFromArray(String ... keyValues) {
        if (keyValues == null) {
            return ImmutableMap.of();
        }
        if (keyValues.length % 2 != 0) {
            this.log.error("Expected even number of key/value pairs, got {}.", (Object)Arrays.toString(keyValues));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return ImmutableMap.copyOf(map);
    }

    public static class Result {
        private final User user;
        private final TransportAddress transportAddress;

        public Result(User user, TransportAddress transportAddress) {
            this.user = user;
            this.transportAddress = transportAddress;
        }

        public User getUser() {
            return this.user;
        }

        public TransportAddress getTransportAddress() {
            return this.transportAddress;
        }
    }
}

