/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.util.Optional;
import org.opensearch.Version;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.security.dlic.rest.api.ssl.CertificatesInfo;
import org.opensearch.security.ssl.config.CertType;

public class CertificatesInfoNodesRequest
extends BaseNodesRequest<CertificatesInfoNodesRequest> {
    private final String certTypeID;
    private final boolean inMemory;

    public CertificatesInfoNodesRequest(String certTypeID, boolean inMemory, String ... nodesIds) {
        super(nodesIds);
        this.certTypeID = certTypeID;
        this.inMemory = inMemory;
    }

    public CertificatesInfoNodesRequest(StreamInput in) throws IOException {
        super(in);
        this.certTypeID = in.getVersion().before(Version.V_3_0_0) ? ((CertificatesInfo.CertificateType_2_19)in.readEnum(CertificatesInfo.CertificateType_2_19.class)).value() : in.readOptionalString();
        this.inMemory = in.readBoolean();
    }

    public Optional<String> certificateType() {
        return Optional.ofNullable(this.certTypeID);
    }

    public boolean inMemory() {
        return this.inMemory;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_3_0_0)) {
            if (this.certTypeID == null) {
                out.writeEnum((Enum)CertificatesInfo.CertificateType_2_19.ALL);
            } else {
                out.writeEnum((Enum)CertificatesInfo.CertificateType_2_19.valueOf(this.certTypeID));
            }
        } else {
            out.writeOptionalString(this.certTypeID);
        }
        out.writeBoolean(this.inMemory);
    }

    public ActionRequestValidationException validate() {
        if (!Strings.isEmpty((CharSequence)this.certTypeID) && !CertType.CERT_TYPE_REGISTRY.contains(this.certTypeID)) {
            ActionRequestValidationException errorMessage = new ActionRequestValidationException();
            errorMessage.addValidationError("wrong certificate type " + this.certTypeID + ". Please use one of " + String.valueOf(CertType.CERT_TYPE_REGISTRY));
            return errorMessage;
        }
        return super.validate();
    }
}

