/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.util.HexBin;
import com.alibaba.druid.util.JdbcUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.servlet.GenericServlet;

public class Utils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static Date startTime;

    public static String read(InputStream in) {
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return Utils.read(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromResource(String resource) throws IOException {
        String text;
        InputStream in;
        block4: {
            String string;
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in == null) {
                    in = Utils.class.getResourceAsStream(resource);
                }
                if (in != null) break block4;
                string = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(in);
                throw throwable;
            }
            JdbcUtils.close(in);
            return string;
        }
        String string = text = Utils.read(in);
        JdbcUtils.close(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArrayFromResource(String resource) throws IOException {
        InputStream in;
        block3: {
            byte[] byArray;
            in = null;
            try {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                if (in != null) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                JdbcUtils.close(in);
                throw throwable;
            }
            JdbcUtils.close(in);
            return byArray;
        }
        byte[] byArray = Utils.readByteArray(in);
        JdbcUtils.close(in);
        return byArray;
    }

    public static byte[] readByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Utils.copy(input, output);
        return output.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int EOF = -1;
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String read(Reader reader, int length) {
        try {
            int len;
            char[] buffer = new char[length];
            int offset = 0;
            int rest = length;
            while ((len = reader.read(buffer, offset, rest)) != -1) {
                offset += len;
                if ((rest -= len) != 0) continue;
            }
            return new String(buffer, 0, length - rest);
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter buf = new StringWriter();
        ex.printStackTrace(new PrintWriter(buf));
        return buf.toString();
    }

    public static String toString(StackTraceElement[] stackTrace) {
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement item : stackTrace) {
            buf.append(item.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public static Boolean getBoolean(Properties properties2, String key) {
        String property = properties2.getProperty(key);
        if ("true".equals(property)) {
            return Boolean.TRUE;
        }
        if ("false".equals(property)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Boolean getBoolean(GenericServlet servlet, String key) {
        String property = servlet.getInitParameter(key);
        if ("true".equals(property)) {
            return Boolean.TRUE;
        }
        if ("false".equals(property)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static Integer getInteger(Properties properties2, String key) {
        String property = properties2.getProperty(key);
        if (property == null) {
            return null;
        }
        try {
            return Integer.parseInt(property);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long getLong(Properties properties2, String key) {
        String property = properties2.getProperty(key);
        if (property == null) {
            return null;
        }
        try {
            return Long.parseLong(property);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Class<?> loadClass(String className) {
        Class<?> clazz = null;
        if (className == null) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            if (ctxClassLoader != null) {
                try {
                    clazz = ctxClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return clazz;
        }
    }

    public static final Date getStartTime() {
        if (startTime == null) {
            startTime = new Date(ManagementFactory.getRuntimeMXBean().getStartTime());
        }
        return startTime;
    }

    public static long murmurhash2_64(String text) {
        byte[] bytes = text.getBytes();
        return Utils.murmurhash2_64(bytes, bytes.length, -512093083);
    }

    public static long murmurhash2_64(byte[] data2, int length, int seed) {
        long m4 = -4132994306676758123L;
        int r = 47;
        long h2 = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long k = ((long)data2[i8 + 0] & 0xFFL) + (((long)data2[i8 + 1] & 0xFFL) << 8) + (((long)data2[i8 + 2] & 0xFFL) << 16) + (((long)data2[i8 + 3] & 0xFFL) << 24) + (((long)data2[i8 + 4] & 0xFFL) << 32) + (((long)data2[i8 + 5] & 0xFFL) << 40) + (((long)data2[i8 + 6] & 0xFFL) << 48) + (((long)data2[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h2 ^= (k *= -4132994306676758123L);
            h2 *= -4132994306676758123L;
        }
        switch (length % 8) {
            case 7: {
                h2 ^= (long)(data2[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                h2 ^= (long)(data2[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                h2 ^= (long)(data2[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                h2 ^= (long)(data2[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                h2 ^= (long)(data2[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                h2 ^= (long)(data2[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                h2 ^= (long)(data2[length & 0xFFFFFFF8] & 0xFF);
                h2 *= -4132994306676758123L;
            }
        }
        h2 ^= h2 >>> 47;
        h2 *= -4132994306676758123L;
        h2 ^= h2 >>> 47;
        return h2;
    }

    public static byte[] md5Bytes(String text) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("System doesn't support MD5 algorithm.");
        }
        msgDigest.update(text.getBytes());
        byte[] bytes = msgDigest.digest();
        return bytes;
    }

    public static String md5(String text) {
        byte[] bytes = Utils.md5Bytes(text);
        return HexBin.encode(bytes, false);
    }

    public static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
    }
}

