/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.kmssdkv2;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.MasterKeyRequest;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.NoSuchMasterKeyException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.AwsKmsCmkArnInfo;
import com.amazonaws.encryptionsdk.kms.DiscoveryFilter;
import com.amazonaws.encryptionsdk.kmssdkv2.AwsKmsMrkAwareMasterKey;
import com.amazonaws.encryptionsdk.kmssdkv2.RegionalClientSupplier;
import com.amazonaws.encryptionsdk.kmssdkv2.RequestClientCacher;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;

public final class AwsKmsMrkAwareMasterKeyProvider
extends MasterKeyProvider<AwsKmsMrkAwareMasterKey> {
    private static final String PROVIDER_NAME = "aws-kms";
    private final List<String> keyIds_;
    private final List<String> grantTokens_;
    private final boolean isDiscovery_;
    private final DiscoveryFilter discoveryFilter_;
    private final Region discoveryMrkRegion_;
    private final RegionalClientSupplier regionalClientSupplier_;
    private final Region defaultRegion_;

    public static Builder builder() {
        return new Builder();
    }

    private AwsKmsMrkAwareMasterKeyProvider(RegionalClientSupplier supplier, Region defaultRegion, List<String> keyIds, List<String> grantTokens, boolean isDiscovery, DiscoveryFilter discoveryFilter, Region discoveryMrkRegion) {
        if (!isDiscovery && (keyIds == null || keyIds.isEmpty())) {
            throw new IllegalArgumentException("Strict mode must be configured with a non-empty list of keyIds.");
        }
        if (!isDiscovery && (keyIds.contains(null) || keyIds.contains(""))) {
            throw new IllegalArgumentException("Strict mode cannot be configured with a null key identifier.");
        }
        AwsKmsMrkAwareMasterKeyProvider.assertMrksAreUnique(keyIds);
        if (!isDiscovery && defaultRegion == null && keyIds.stream().map(AwsKmsCmkArnInfo::parseInfoFromKeyArn).anyMatch(Objects::isNull)) {
            throw new AwsCryptoException("Can't use non-ARN key identifiers or aliases when no default region is set");
        }
        if (!isDiscovery && discoveryFilter != null) {
            throw new IllegalArgumentException("Strict mode cannot be configured with a discovery filter.");
        }
        if (isDiscovery && !keyIds.isEmpty()) {
            throw new IllegalArgumentException("Discovery mode can not be configured with keys.");
        }
        if (isDiscovery && discoveryMrkRegion == null) {
            throw new IllegalArgumentException("Discovery MRK region can not be null.");
        }
        this.regionalClientSupplier_ = supplier;
        this.defaultRegion_ = defaultRegion;
        this.keyIds_ = Collections.unmodifiableList(new ArrayList<String>(keyIds));
        this.isDiscovery_ = isDiscovery;
        this.discoveryFilter_ = discoveryFilter;
        this.discoveryMrkRegion_ = discoveryMrkRegion;
        this.grantTokens_ = grantTokens;
    }

    static void assertMrksAreUnique(List<String> keyIdentifiers) {
        List duplicateMultiRegionKeyIdentifiers = keyIdentifiers.stream().collect(Collectors.groupingBy(AwsKmsMrkAwareMasterKeyProvider::getResourceForResourceTypeKey)).entrySet().stream().filter(maybeDuplicate -> ((List)maybeDuplicate.getValue()).size() > 1).filter(maybeMrk -> AwsKmsCmkArnInfo.isMRK((String)maybeMrk.getKey())).flatMap(mrkEntry -> ((List)mrkEntry.getValue()).stream()).collect(Collectors.toList());
        if (duplicateMultiRegionKeyIdentifiers.size() > 1) {
            throw new IllegalArgumentException("Duplicate multi-region keys are not allowed:\n" + String.join((CharSequence)", ", duplicateMultiRegionKeyIdentifiers));
        }
    }

    static String getResourceForResourceTypeKey(String identifier) {
        AwsKmsCmkArnInfo info = AwsKmsCmkArnInfo.parseInfoFromKeyArn(identifier);
        if (info == null) {
            return identifier;
        }
        if (!info.getResourceType().equals("key")) {
            return identifier;
        }
        return info.getResource();
    }

    @Override
    public String getDefaultProviderId() {
        return PROVIDER_NAME;
    }

    @Override
    public AwsKmsMrkAwareMasterKey getMasterKey(String providerId, String requestedKeyArn) throws UnsupportedProviderException, NoSuchMasterKeyException {
        if (!this.canProvide(providerId)) {
            throw new UnsupportedProviderException();
        }
        Optional<String> matchedArn = this.keyIds_.stream().filter(t2 -> AwsKmsCmkArnInfo.awsKmsArnMatchForDecrypt(t2, requestedKeyArn)).findFirst();
        if (!this.isDiscovery_ && !matchedArn.isPresent()) {
            throw new NoSuchMasterKeyException("Key must be in supplied list of keyIds.");
        }
        AwsKmsCmkArnInfo requestedKeyArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(requestedKeyArn);
        if (this.isDiscovery_ && requestedKeyArnInfo == null) {
            throw new NoSuchMasterKeyException("Cannot use AWS KMS identifiers when in discovery mode.");
        }
        if (this.isDiscovery_ && this.discoveryFilter_ != null && !this.discoveryFilter_.allowsPartitionAndAccount(requestedKeyArnInfo.getPartition(), requestedKeyArnInfo.getAccountId())) {
            throw new NoSuchMasterKeyException("Cannot use key in partition " + requestedKeyArnInfo.getPartition() + " with account id " + requestedKeyArnInfo.getAccountId() + " with configured discovery filter.");
        }
        Region region_ = AwsKmsMrkAwareMasterKeyProvider.extractRegion(this.defaultRegion_, this.discoveryMrkRegion_, matchedArn, requestedKeyArnInfo, this.isDiscovery_);
        KmsClient client = this.regionalClientSupplier_.getClient(region_);
        String keyIdentifier = this.isDiscovery_ ? requestedKeyArnInfo.toString(region_.id()) : matchedArn.get();
        AwsKmsMrkAwareMasterKey result2 = AwsKmsMrkAwareMasterKey.getInstance(client, keyIdentifier, this);
        result2.setGrantTokens(this.grantTokens_);
        return result2;
    }

    static Region extractRegion(Region defaultRegion, Region discoveryMrkRegion, Optional<String> matchedArn, AwsKmsCmkArnInfo requestedKeyArnInfo, boolean isDiscovery) {
        if (requestedKeyArnInfo == null) {
            return defaultRegion;
        }
        if (!AwsKmsCmkArnInfo.isMRK(requestedKeyArnInfo.getResource()) || !requestedKeyArnInfo.getResourceType().equals("key")) {
            return Region.of((String)requestedKeyArnInfo.getRegion());
        }
        if (isDiscovery) {
            return discoveryMrkRegion;
        }
        return Region.of((String)AwsKmsCmkArnInfo.parseInfoFromKeyArn(matchedArn.get()).getRegion());
    }

    @Override
    public List<AwsKmsMrkAwareMasterKey> getMasterKeysForEncryption(MasterKeyRequest request) {
        if (this.isDiscovery_) {
            return Collections.emptyList();
        }
        ArrayList<AwsKmsMrkAwareMasterKey> result2 = new ArrayList<AwsKmsMrkAwareMasterKey>(this.keyIds_.size());
        for (String id : this.keyIds_) {
            result2.add((AwsKmsMrkAwareMasterKey)this.getMasterKey(id));
        }
        return result2;
    }

    @Override
    public DataKey<AwsKmsMrkAwareMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws AwsCryptoException {
        ArrayList exceptions = new ArrayList();
        return encryptedDataKeys.stream().filter(edk -> {
            if (!this.canProvide(edk.getProviderId())) {
                return false;
            }
            String providerInfo = new String(edk.getProviderInformation(), StandardCharsets.UTF_8);
            AwsKmsCmkArnInfo providerArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(providerInfo);
            if (providerArnInfo == null || !"key".equals(providerArnInfo.getResourceType())) {
                throw new IllegalStateException("Invalid provider info in message.");
            }
            return true;
        }).map(edk -> {
            try {
                String keyArn = new String(edk.getProviderInformation(), StandardCharsets.UTF_8);
                return this.getMasterKey(edk.getProviderId(), keyArn).decryptDataKey(algorithm, Collections.singletonList(edk), encryptionContext);
            }
            catch (Exception ex) {
                exceptions.add(ex);
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> this.buildCannotDecryptDksException(exceptions));
    }

    public List<String> getGrantTokens() {
        return new ArrayList<String>(this.grantTokens_);
    }

    public AwsKmsMrkAwareMasterKeyProvider withGrantTokens(List<String> grantTokens) {
        grantTokens = Collections.unmodifiableList(new ArrayList<String>(grantTokens));
        return new AwsKmsMrkAwareMasterKeyProvider(this.regionalClientSupplier_, this.defaultRegion_, this.keyIds_, grantTokens, this.isDiscovery_, this.discoveryFilter_, this.discoveryMrkRegion_);
    }

    public AwsKmsMrkAwareMasterKeyProvider withGrantTokens(String ... grantTokens) {
        return this.withGrantTokens(Arrays.asList(grantTokens));
    }

    public static class Builder
    implements Cloneable {
        private Region defaultRegion_ = Builder.getSdkDefaultRegion();
        private Supplier<KmsClientBuilder> builderSupplier_ = null;
        private RegionalClientSupplier regionalClientSupplier_ = null;
        private DiscoveryFilter discoveryFilter_ = null;
        private Region discoveryMrkRegion_ = this.defaultRegion_;

        Builder() {
        }

        public Builder clone() {
            try {
                Builder cloned = (Builder)super.clone();
                cloned.builderSupplier_ = this.builderSupplier_;
                return cloned;
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Impossible: CloneNotSupportedException", e);
            }
        }

        public Builder defaultRegion(Region defaultRegion) {
            this.defaultRegion_ = defaultRegion;
            return this;
        }

        public Builder discoveryMrkRegion(Region discoveryMrkRegion) {
            this.discoveryMrkRegion_ = discoveryMrkRegion;
            return this;
        }

        public Builder customRegionalClientSupplier(RegionalClientSupplier regionalClientSupplier) {
            if (this.builderSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            this.regionalClientSupplier_ = regionalClientSupplier;
            return this;
        }

        public Builder builderSupplier(Supplier<KmsClientBuilder> supplier) {
            if (this.regionalClientSupplier_ != null) {
                throw this.clientSupplierComboException();
            }
            this.builderSupplier_ = supplier;
            return this;
        }

        private RuntimeException clientSupplierComboException() {
            return new IllegalStateException("only one of builderSupplier and customRegionalClientSupplier may be used");
        }

        public AwsKmsMrkAwareMasterKeyProvider buildDiscovery() {
            boolean isDiscovery = true;
            RegionalClientSupplier clientSupplier = this.regionalClientSupplier_;
            if (clientSupplier == null) {
                clientSupplier = Builder.clientFactory(new ConcurrentHashMap<Region, KmsClient>(), this.builderSupplier_);
            }
            return new AwsKmsMrkAwareMasterKeyProvider(clientSupplier, this.defaultRegion_, Collections.emptyList(), Collections.emptyList(), true, this.discoveryFilter_, this.discoveryMrkRegion_ == null ? this.defaultRegion_ : this.discoveryMrkRegion_);
        }

        public AwsKmsMrkAwareMasterKeyProvider buildDiscovery(DiscoveryFilter filter) {
            this.discoveryFilter_ = filter;
            return this.buildDiscovery();
        }

        public AwsKmsMrkAwareMasterKeyProvider buildStrict(List<String> keyIds) {
            boolean isDiscovery = false;
            RegionalClientSupplier clientSupplier = this.regionalClientSupplier_;
            if (clientSupplier == null) {
                clientSupplier = Builder.clientFactory(new ConcurrentHashMap<Region, KmsClient>(), this.builderSupplier_);
            }
            return new AwsKmsMrkAwareMasterKeyProvider(clientSupplier, this.defaultRegion_, new ArrayList<String>(keyIds), Collections.emptyList(), false, null, null);
        }

        public AwsKmsMrkAwareMasterKeyProvider buildStrict(String ... keyIds) {
            return this.buildStrict(Arrays.asList(keyIds));
        }

        static RegionalClientSupplier clientFactory(ConcurrentHashMap<Region, KmsClient> clientCache, Supplier<KmsClientBuilder> builderSupplier) {
            return region -> {
                if (clientCache.containsKey(region)) {
                    return (KmsClient)clientCache.get(region);
                }
                KmsClientBuilder builder = builderSupplier != null ? (KmsClientBuilder)builderSupplier.get() : KmsClient.builder();
                RequestClientCacher cacher = new RequestClientCacher(clientCache, region);
                KmsClient client = (KmsClient)((KmsClientBuilder)((KmsClientBuilder)builder.region(region)).overrideConfiguration(config -> config.addExecutionInterceptor((ExecutionInterceptor)cacher))).build();
                return cacher.setClient(client);
            };
        }

        private static Region getSdkDefaultRegion() {
            try {
                return new DefaultAwsRegionProviderChain().getRegion();
            }
            catch (SdkClientException ex) {
                return null;
            }
        }
    }
}

