/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.mutable;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.util.Spaces;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.mutable.MutableRelType;
import org.apache.calcite.rel.mutable.MutableRelVisitor;
import org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Equivalence;

public abstract class MutableRel {
    protected static final Equivalence<Object> STRING_EQUIVALENCE = new Equivalence<Object>(){

        @Override
        protected boolean doEquivalent(Object o, Object o2) {
            return o.toString().equals(o2.toString());
        }

        @Override
        protected int doHash(Object o) {
            return o.toString().hashCode();
        }
    };
    protected static final Equivalence<List<?>> PAIRWISE_STRING_EQUIVALENCE = STRING_EQUIVALENCE.pairwise();
    public final RelOptCluster cluster;
    public final RelDataType rowType;
    protected final MutableRelType type;
    protected @Nullable MutableRel parent;
    protected int ordinalInParent;

    protected MutableRel(RelOptCluster cluster, RelDataType rowType, MutableRelType type2) {
        this.cluster = Objects.requireNonNull(cluster, "cluster");
        this.rowType = Objects.requireNonNull(rowType, "rowType");
        this.type = Objects.requireNonNull(type2, "type");
    }

    public @Nullable MutableRel getParent() {
        return this.parent;
    }

    public abstract void setInput(int var1, MutableRel var2);

    public abstract List<MutableRel> getInputs();

    public abstract MutableRel clone();

    public abstract void childrenAccept(MutableRelVisitor var1);

    public @Nullable MutableRel replaceInParent(MutableRel child) {
        MutableRel parent = this.parent;
        if (this != child && parent != null) {
            parent.setInput(this.ordinalInParent, child);
            this.parent = null;
            this.ordinalInParent = 0;
        }
        return parent;
    }

    public abstract StringBuilder digest(StringBuilder var1);

    public final String deep() {
        return new MutableRelDumper().apply(this);
    }

    public final String toString() {
        return this.deep();
    }

    private static class MutableRelDumper
    extends MutableRelVisitor {
        private final StringBuilder buf = new StringBuilder();
        private int level;

        private MutableRelDumper() {
        }

        @Override
        public void visit(@Nullable MutableRel node) {
            Spaces.append(this.buf, this.level * 2);
            if (node == null) {
                this.buf.append("null");
            } else {
                node.digest(this.buf);
                this.buf.append("\n");
                ++this.level;
                super.visit(node);
                --this.level;
            }
        }

        public String apply(MutableRel rel) {
            this.go(rel);
            return this.buf.toString();
        }
    }
}

