/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;

public class RexOver
extends RexCall {
    private static final Finder FINDER = new Finder();
    private final RexWindow window;
    private final boolean distinct;
    private final boolean ignoreNulls;

    RexOver(RelDataType type2, SqlAggFunction op, List<RexNode> operands, RexWindow window, boolean distinct2, boolean ignoreNulls) {
        super(type2, op, operands);
        Preconditions.checkArgument(op.isAggregator());
        this.window = Objects.requireNonNull(window, "window");
        this.distinct = distinct2;
        this.ignoreNulls = ignoreNulls;
    }

    public SqlAggFunction getAggOperator() {
        return (SqlAggFunction)this.getOperator();
    }

    public RexWindow getWindow() {
        return this.window;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        sb.append("(");
        if (this.distinct) {
            sb.append("DISTINCT ");
        }
        this.appendOperands(sb);
        sb.append(")");
        if (this.ignoreNulls) {
            sb.append(" IGNORE NULLS");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        sb.append(" OVER (");
        this.window.appendDigest(sb, this.op.allowsFraming()).append(")");
        return sb.toString();
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor2) {
        return visitor2.visitOver(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor2, P arg) {
        return visitor2.visitOver(this, arg);
    }

    @Override
    public int nodeCount() {
        return super.nodeCount() + this.window.nodeCount;
    }

    public static boolean containsOver(RexNode expr) {
        try {
            expr.accept(FINDER);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(RexProgram program) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, program.getExprList(), null);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsOver(List<? extends RexNode> exprs, @Nullable RexNode condition) {
        try {
            RexUtil.apply((RexVisitor<Void>)FINDER, exprs, condition);
            return false;
        }
        catch (OverFound e) {
            Util.swallow(e, null);
            return true;
        }
    }

    @Override
    public RexCall clone(RelDataType type2, List<RexNode> operands) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RexOver rexOver = (RexOver)o;
        return this.distinct == rexOver.distinct && this.ignoreNulls == rexOver.ignoreNulls && this.window.equals(rexOver.window) && this.op.allowsFraming() == rexOver.op.allowsFraming();
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(super.hashCode(), this.window, this.distinct, this.ignoreNulls, this.op.allowsFraming());
        }
        return this.hash;
    }

    private static class Finder
    extends RexVisitorImpl<Void> {
        Finder() {
            super(true);
        }

        @Override
        public Void visitOver(RexOver over) {
            throw OverFound.INSTANCE;
        }
    }

    private static class OverFound
    extends ControlFlowException {
        public static final OverFound INSTANCE = new OverFound();

        private OverFound() {
        }
    }
}

