/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Arrays;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Static;

public class SqlDotOperator
extends SqlSpecialOperator {
    SqlDotOperator() {
        super("DOT", SqlKind.DOT, 100, true, null, null, null);
    }

    @Override
    public SqlSpecialOperator.ReduceResult reduceExpr(int ordinal, SqlSpecialOperator.TokenSequence list) {
        SqlNode left = list.node(ordinal - 1);
        SqlNode right = list.node(ordinal + 1);
        return new SqlSpecialOperator.ReduceResult(ordinal - 1, ordinal + 2, this.createCall(SqlParserPos.sum(Arrays.asList(Objects.requireNonNull(left, "left").getParserPosition(), Objects.requireNonNull(right, "right").getParserPosition(), list.pos(ordinal))), left, right));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, 0);
        writer.sep(".");
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        writer.endList(frame);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor2, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (onlyExpressions) {
            argHandler.visitChild(visitor2, call, 0, (SqlNode)call.operand(0));
        } else {
            super.acceptCall(visitor2, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope2, SqlCall call) {
        SqlNode operand = call.getOperandList().get(0);
        RelDataType nodeType = Objects.requireNonNull(validator.deriveType(scope2, operand));
        if (!nodeType.isStruct()) {
            throw SqlUtil.newContextException(operand.getParserPosition(), Static.RESOURCE.incompatibleTypes());
        }
        Object fieldId = call.operand(1);
        String fieldName = ((SqlNode)fieldId).toString();
        RelDataTypeField field = nodeType.getField(fieldName, false, false);
        if (field == null) {
            throw SqlUtil.newContextException(((SqlNode)fieldId).getParserPosition(), Static.RESOURCE.unknownField(fieldName));
        }
        RelDataType type2 = field.getType();
        if (nodeType.isNullable()) {
            type2 = validator.getTypeFactory().createTypeWithNullability(type2, true);
        }
        type2 = this.adjustType(validator, call, type2);
        SqlValidatorUtil.checkCharsetAndCollateConsistentIfCharType(type2);
        return type2;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope2, SqlValidatorScope operandScope) {
        assert (call.getOperator() == this);
        call.getOperandList().get(0).validateExpr(validator, operandScope);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        RelDataType type2 = SqlTypeUtil.deriveType(callBinding, left);
        if (type2.getSqlTypeName() != SqlTypeName.ROW) {
            return false;
        }
        if (Objects.requireNonNull(type2.getSqlIdentifier(), () -> "type.getSqlIdentifier() is null for " + type2).isStar()) {
            return false;
        }
        RelDataType operandType = callBinding.getOperandType(0);
        SqlSingleOperandTypeChecker checker = SqlDotOperator.getChecker(operandType);
        return checker.checkSingleOperandType(callBinding, right, 0, throwOnFailure);
    }

    private static SqlSingleOperandTypeChecker getChecker(RelDataType operandType) {
        switch (operandType.getSqlTypeName()) {
            case ROW: {
                return OperandTypes.family(SqlTypeFamily.STRING);
            }
        }
        throw new AssertionError((Object)operandType.getSqlTypeName());
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        return litmus.fail("DOT is valid only for SqlCall not for RexCall", new Object[0]);
    }

    @Override
    public String getAllowedSignatures(String name) {
        return "<A>.<B>";
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType recordType = opBinding.getOperandType(0);
        switch (recordType.getSqlTypeName()) {
            case ROW: {
                String fieldName = SqlNonNullableAccessors.getOperandLiteralValueOrThrow(opBinding, 1, String.class);
                RelDataTypeField field = Objects.requireNonNull(recordType.getField(fieldName, false, false), () -> "field " + fieldName + " is not found in " + recordType);
                RelDataType type2 = field.getType();
                if (recordType.isNullable()) {
                    return typeFactory.createTypeWithNullability(type2, true);
                }
                return type2;
            }
        }
        throw new AssertionError();
    }
}

