/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;

abstract class AbstractNamespace
implements SqlValidatorNamespace {
    protected final SqlValidatorImpl validator;
    private SqlValidatorImpl.Status status = SqlValidatorImpl.Status.UNVALIDATED;
    protected @Nullable RelDataType rowType;
    protected @Nullable RelDataType type;
    protected ImmutableBitSet mustFilterFields = ImmutableBitSet.of();
    protected final @Nullable SqlNode enclosingNode;

    AbstractNamespace(SqlValidatorImpl validator, @Nullable SqlNode enclosingNode) {
        this.validator = validator;
        this.enclosingNode = enclosingNode;
    }

    @Override
    public SqlValidator getValidator() {
        return this.validator;
    }

    @Override
    public final void validate(RelDataType targetRowType) {
        switch (this.status) {
            case UNVALIDATED: {
                try {
                    this.status = SqlValidatorImpl.Status.IN_PROGRESS;
                    Preconditions.checkArgument(this.rowType == null, "Namespace.rowType must be null before validate has been called");
                    RelDataType type2 = this.validateImpl(targetRowType);
                    Objects.requireNonNull(type2, "validateImpl() returned null");
                    this.setType(type2);
                    break;
                }
                finally {
                    this.status = SqlValidatorImpl.Status.VALID;
                }
            }
            case IN_PROGRESS: {
                throw new AssertionError((Object)"Cycle detected during type-checking");
            }
            case VALID: {
                break;
            }
            default: {
                throw Util.unexpected(this.status);
            }
        }
    }

    protected abstract RelDataType validateImpl(RelDataType var1);

    @Override
    public RelDataType getRowType() {
        if (this.rowType == null) {
            this.validator.validateNamespace(this, this.validator.unknownType);
            Objects.requireNonNull(this.rowType, "validate must set rowType");
        }
        return this.rowType;
    }

    @Override
    public RelDataType getRowTypeSansSystemColumns() {
        return this.getRowType();
    }

    @Override
    public RelDataType getType() {
        Util.discard(this.getRowType());
        return Objects.requireNonNull(this.type, "type");
    }

    @Override
    public void setType(RelDataType type2) {
        this.type = type2;
        this.rowType = this.convertToStruct(type2);
    }

    @Override
    public @Nullable SqlNode getEnclosingNode() {
        return this.enclosingNode;
    }

    @Override
    public @Nullable SqlValidatorTable getTable() {
        return null;
    }

    @Override
    public @Nullable SqlValidatorNamespace lookupChild(String name) {
        return this.validator.lookupFieldNamespace(this.getRowType(), name);
    }

    @Override
    public @Nullable RelDataTypeField field(String name) {
        RelDataType rowType = this.getRowType();
        return this.validator.catalogReader.nameMatcher().field(rowType, name);
    }

    @Override
    public List<Pair<SqlNode, SqlMonotonicity>> getMonotonicExprs() {
        return ImmutableList.of();
    }

    @Override
    public ImmutableBitSet getMustFilterFields() {
        return Objects.requireNonNull(this.mustFilterFields, "mustFilterFields (maybe validation is not complete?)");
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public void makeNullable() {
    }

    public String translate(String name) {
        return name;
    }

    @Override
    public SqlValidatorNamespace resolve() {
        return this;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return true;
    }

    @Override
    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    protected RelDataType convertToStruct(RelDataType type2) {
        RelDataType collectionType;
        RelDataType componentType = type2.getComponentType();
        if (componentType == null || componentType.isStruct()) {
            return type2;
        }
        RelDataTypeFactory typeFactory = this.validator.getTypeFactory();
        RelDataType structType = this.toStruct(componentType, this.getNode());
        switch (type2.getSqlTypeName()) {
            case ARRAY: {
                collectionType = typeFactory.createArrayType(structType, -1L);
                break;
            }
            case MULTISET: {
                collectionType = typeFactory.createMultisetType(structType, -1L);
                break;
            }
            default: {
                throw new AssertionError(type2);
            }
        }
        return typeFactory.createTypeWithNullability(collectionType, type2.isNullable());
    }

    protected RelDataType toStruct(RelDataType type2, @Nullable SqlNode unnest) {
        if (type2.isStruct()) {
            return type2;
        }
        return this.validator.getTypeFactory().builder().add(SqlValidatorUtil.alias(Objects.requireNonNull(unnest, "unnest"), 0), type2).build();
    }
}

