/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.proj4j.util.Pair;

public class Proj4FileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readParametersFromFile(String authorityCode, String name) throws IOException {
        String[] args2;
        String filename = "proj4/nad/" + authorityCode.toLowerCase();
        InputStream inStr = Proj4FileReader.class.getClassLoader().getResourceAsStream(filename);
        if (inStr == null) {
            throw new IllegalStateException("Unable to access CRS file: " + filename);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inStr));){
            args2 = this.readFile(reader, name);
        }
        return args2;
    }

    private StreamTokenizer createTokenizer(BufferedReader reader) {
        StreamTokenizer t2 = new StreamTokenizer(reader);
        t2.commentChar(35);
        t2.ordinaryChars(48, 57);
        t2.ordinaryChars(46, 46);
        t2.ordinaryChars(45, 45);
        t2.ordinaryChars(43, 43);
        t2.wordChars(48, 57);
        t2.wordChars(39, 39);
        t2.wordChars(34, 34);
        t2.wordChars(95, 95);
        t2.wordChars(46, 46);
        t2.wordChars(45, 45);
        t2.wordChars(43, 43);
        t2.wordChars(44, 44);
        t2.wordChars(64, 64);
        return t2;
    }

    private String[] readFile(BufferedReader reader, String name) throws IOException {
        StreamTokenizer t2 = this.createTokenizer(reader);
        t2.nextToken();
        while (t2.ttype == 60) {
            Pair<String, List> pair = Proj4FileReader.parseTokenizer(t2);
            String crsName = pair.fst();
            List v = pair.snd();
            if (!crsName.equals(name)) continue;
            String[] args2 = v.toArray(new String[0]);
            return args2;
        }
        return null;
    }

    private static void addParam(List v, String key, String value) {
        String plusKey = key;
        if (!key.startsWith("+")) {
            plusKey = "+" + key;
        }
        if (value != null) {
            v.add(plusKey + "=" + value);
        } else {
            v.add(plusKey);
        }
    }

    public String[] getParameters(String crsName) {
        try {
            int p = crsName.indexOf(58);
            if (p >= 0) {
                String auth = crsName.substring(0, p);
                String id = crsName.substring(p + 1);
                return this.readParametersFromFile(auth, id);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String readEpsgCodeFromFile(String[] params) throws IOException {
        InputStream inStr = Proj4FileReader.class.getClassLoader().getResourceAsStream("proj4/nad/epsg");
        if (inStr == null) {
            throw new IllegalStateException("Unable to access CRS file: EPSG");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStr));
        StreamTokenizer t2 = this.createTokenizer(reader);
        t2.nextToken();
        while (t2.ttype == 60) {
            Pair<String, List> pair = Proj4FileReader.parseTokenizer(t2);
            String crsName = pair.fst();
            List v = pair.snd();
            Object[] paramsParsed = v.toArray(new String[0]);
            if (!Arrays.equals(params, paramsParsed)) continue;
            return crsName;
        }
        return null;
    }

    private static Pair<String, List> parseTokenizer(StreamTokenizer t2) throws IOException {
        t2.nextToken();
        if (t2.ttype != -3) {
            throw new IOException(t2.lineno() + ": Word expected after '<'");
        }
        String crsName = t2.sval;
        t2.nextToken();
        if (t2.ttype != 62) {
            throw new IOException(t2.lineno() + ": '>' expected");
        }
        t2.nextToken();
        ArrayList v = new ArrayList();
        while (t2.ttype != 60) {
            if (t2.ttype == 43) {
                t2.nextToken();
            }
            if (t2.ttype != -3) {
                throw new IOException(t2.lineno() + ": Word expected after '+'");
            }
            String key = t2.sval;
            t2.nextToken();
            if (t2.ttype == 61) {
                t2.nextToken();
                String value = t2.sval;
                t2.nextToken();
                Proj4FileReader.addParam(v, key, value);
                continue;
            }
            Proj4FileReader.addParam(v, key, null);
        }
        t2.nextToken();
        if (t2.ttype != 62) {
            throw new IOException(t2.lineno() + ": '<>' expected");
        }
        t2.nextToken();
        return Pair.create(crsName, v);
    }
}

