/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.StatusLine;
import org.opensearch.client.Node;

final class RequestLogger {
    private static final Log tracer = LogFactory.getLog("tracer");

    private RequestLogger() {
    }

    static void logResponse(Log logger2, HttpUriRequest request, HttpHost host, ClassicHttpResponse httpResponse) {
        Header[] warnings;
        if (logger2.isDebugEnabled()) {
            logger2.debug("request [" + request.getMethod() + " " + host + RequestLogger.getUri(request) + "] returned [" + new StatusLine(httpResponse) + "]");
        }
        if (logger2.isWarnEnabled() && (warnings = httpResponse.getHeaders("Warning")) != null && warnings.length > 0) {
            logger2.warn(RequestLogger.buildWarningMessage(request, host, warnings));
        }
        if (tracer.isTraceEnabled()) {
            String responseLine;
            String requestLine;
            try {
                requestLine = RequestLogger.buildTraceRequest(request, host);
            }
            catch (IOException e) {
                requestLine = "";
                tracer.trace("error while reading request for trace purposes", e);
            }
            try {
                responseLine = RequestLogger.buildTraceResponse(httpResponse);
            }
            catch (IOException e) {
                responseLine = "";
                tracer.trace("error while reading response for trace purposes", e);
            }
            tracer.trace(requestLine + '\n' + responseLine);
        }
    }

    static void logFailedRequest(Log logger2, HttpUriRequest request, Node node, Exception e) {
        if (logger2.isDebugEnabled()) {
            logger2.debug("request [" + request.getMethod() + " " + node.getHost() + RequestLogger.getUri(request) + "] failed", e);
        }
        if (tracer.isTraceEnabled()) {
            String traceRequest;
            try {
                traceRequest = RequestLogger.buildTraceRequest(request, node.getHost());
            }
            catch (IOException e1) {
                tracer.trace("error while reading request for trace purposes", e);
                traceRequest = "";
            }
            tracer.trace(traceRequest);
        }
    }

    static String buildWarningMessage(HttpUriRequest request, HttpHost host, Header[] warnings) {
        StringBuilder message = new StringBuilder("request [").append(request.getMethod()).append(" ").append(host).append(RequestLogger.getUri(request)).append("] returned ").append(warnings.length).append(" warnings: ");
        for (int i = 0; i < warnings.length; ++i) {
            if (i > 0) {
                message.append(",");
            }
            message.append("[").append(warnings[i].getValue()).append("]");
        }
        return message.toString();
    }

    static String buildTraceRequest(HttpUriRequest request, HttpHost host) throws IOException {
        String requestLine = "curl -iX " + request.getMethod() + " '" + host + RequestLogger.getUri(request) + "'";
        if (request.getEntity() != null) {
            requestLine = requestLine + " -d '";
            HttpEntity entity = request.getEntity();
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(request.getEntity());
                request.setEntity(entity);
            }
            try {
                requestLine = requestLine + EntityUtils.toString(entity, StandardCharsets.UTF_8) + "'";
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }
        return requestLine;
    }

    static String buildTraceResponse(ClassicHttpResponse httpResponse) throws IOException {
        StringBuilder responseLine = new StringBuilder();
        responseLine.append("# ").append(new StatusLine(httpResponse));
        for (Header header : httpResponse.getHeaders()) {
            responseLine.append("\n# ").append(header.getName()).append(": ").append(header.getValue());
        }
        responseLine.append("\n#");
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            if (!entity.isRepeatable()) {
                entity = new BufferedHttpEntity(entity);
            }
            httpResponse.setEntity(entity);
            ContentType contentType = ContentType.parse(entity.getContentType());
            Charset charset = StandardCharsets.UTF_8;
            if (contentType != null && contentType.getCharset() != null) {
                charset = contentType.getCharset();
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), charset));){
                String line;
                while ((line = reader.readLine()) != null) {
                    responseLine.append("\n# ").append(line);
                }
            }
        }
        return responseLine.toString();
    }

    private static String getUri(HttpUriRequest request) {
        String uri = request.getRequestUri();
        if (uri == null) {
            return "/";
        }
        if (!uri.startsWith("/")) {
            return "/" + uri;
        }
        return uri;
    }
}

