/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLMemorySession
implements ToXContentObject,
Writeable {
    private String ownerId;
    private String memoryContainerId;
    private String summary;
    private Instant createdTime;
    private Instant lastUpdateTime;
    private Map<String, Object> metadata;
    private Map<String, Object> agents;
    private Map<String, Object> additionalInfo;
    private Map<String, String> namespace;
    private String tenantId;

    public MLMemorySession(String ownerId, String memoryContainerId, String summary, Instant createdTime, Instant lastUpdateTime, Map<String, Object> metadata2, Map<String, Object> agents, Map<String, Object> additionalInfo, Map<String, String> namespace, String tenantId) {
        this.ownerId = ownerId;
        this.memoryContainerId = memoryContainerId;
        this.summary = summary;
        this.createdTime = createdTime;
        this.lastUpdateTime = lastUpdateTime;
        this.metadata = metadata2;
        this.agents = agents;
        this.additionalInfo = additionalInfo;
        this.namespace = namespace;
        this.tenantId = tenantId;
    }

    public MLMemorySession(StreamInput in) throws IOException {
        this.ownerId = in.readOptionalString();
        this.memoryContainerId = in.readOptionalString();
        this.summary = in.readOptionalString();
        this.createdTime = in.readOptionalInstant();
        this.lastUpdateTime = in.readOptionalInstant();
        if (in.readBoolean()) {
            this.metadata = in.readMap();
        }
        if (in.readBoolean()) {
            this.agents = in.readMap();
        }
        if (in.readBoolean()) {
            this.additionalInfo = in.readMap();
        }
        if (in.readBoolean()) {
            this.namespace = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.tenantId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.ownerId);
        out.writeOptionalString(this.memoryContainerId);
        out.writeOptionalString(this.summary);
        out.writeOptionalInstant(this.createdTime);
        out.writeOptionalInstant(this.lastUpdateTime);
        if (this.metadata != null) {
            out.writeBoolean(true);
            out.writeMap(this.metadata);
        } else {
            out.writeBoolean(false);
        }
        if (this.agents != null) {
            out.writeBoolean(true);
            out.writeMap(this.agents);
        } else {
            out.writeBoolean(false);
        }
        if (this.additionalInfo != null) {
            out.writeBoolean(true);
            out.writeMap(this.additionalInfo);
        } else {
            out.writeBoolean(false);
        }
        if (this.namespace != null) {
            out.writeBoolean(true);
            out.writeMap(this.namespace, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.tenantId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.ownerId != null) {
            builder.field("owner_id", this.ownerId);
        }
        if (this.memoryContainerId != null) {
            builder.field("memory_container_id", this.memoryContainerId);
        }
        if (this.summary != null) {
            builder.field("summary", this.summary);
        }
        if (this.createdTime != null) {
            builder.field("created_time", this.createdTime.toEpochMilli());
        }
        if (this.lastUpdateTime != null) {
            builder.field("last_updated_time", this.lastUpdateTime.toEpochMilli());
        }
        if (this.metadata != null) {
            builder.field("metadata", this.metadata);
        }
        if (this.agents != null) {
            builder.field("agents", this.agents);
        }
        if (this.additionalInfo != null) {
            builder.field("additional_info", this.additionalInfo);
        }
        if (this.namespace != null) {
            builder.field("namespace", this.namespace);
        }
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MLMemorySession parse(XContentParser parser) throws IOException {
        String ownerId = null;
        String memoryContainerId = null;
        String summary = null;
        Instant createdTime = null;
        Instant lastUpdateTime = null;
        Map metadata2 = null;
        Map agents = null;
        Map additionalInfo = null;
        Map namespace = null;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "owner_id": {
                    ownerId = parser.text();
                    continue block24;
                }
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block24;
                }
                case "summary": {
                    summary = parser.text();
                    continue block24;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block24;
                }
                case "last_updated_time": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block24;
                }
                case "metadata": {
                    metadata2 = parser.map();
                    continue block24;
                }
                case "agents": {
                    agents = parser.map();
                    continue block24;
                }
                case "additional_info": {
                    additionalInfo = parser.map();
                    continue block24;
                }
                case "namespace": {
                    namespace = parser.mapStrings();
                    continue block24;
                }
                case "tenant_id": {
                    tenantId = parser.text();
                    continue block24;
                }
            }
            parser.skipChildren();
        }
        return MLMemorySession.builder().ownerId(ownerId).memoryContainerId(memoryContainerId).summary(summary).createdTime(createdTime).lastUpdateTime(lastUpdateTime).metadata(metadata2).agents(agents).additionalInfo(additionalInfo).namespace(namespace).tenantId(tenantId).build();
    }

    @Generated
    public static MLMemorySessionBuilder builder() {
        return new MLMemorySessionBuilder();
    }

    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public String getSummary() {
        return this.summary;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, Object> getAgents() {
        return this.agents;
    }

    @Generated
    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public Map<String, String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Generated
    public void setMemoryContainerId(String memoryContainerId) {
        this.memoryContainerId = memoryContainerId;
    }

    @Generated
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastUpdateTime(Instant lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setMetadata(Map<String, Object> metadata2) {
        this.metadata = metadata2;
    }

    @Generated
    public void setAgents(Map<String, Object> agents) {
        this.agents = agents;
    }

    @Generated
    public void setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Generated
    public void setNamespace(Map<String, String> namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public static class MLMemorySessionBuilder {
        @Generated
        private String ownerId;
        @Generated
        private String memoryContainerId;
        @Generated
        private String summary;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdateTime;
        @Generated
        private Map<String, Object> metadata;
        @Generated
        private Map<String, Object> agents;
        @Generated
        private Map<String, Object> additionalInfo;
        @Generated
        private Map<String, String> namespace;
        @Generated
        private String tenantId;

        @Generated
        MLMemorySessionBuilder() {
        }

        @Generated
        public MLMemorySessionBuilder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder metadata(Map<String, Object> metadata2) {
            this.metadata = metadata2;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder agents(Map<String, Object> agents) {
            this.agents = agents;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder additionalInfo(Map<String, Object> additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder namespace(Map<String, String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MLMemorySessionBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MLMemorySession build() {
            return new MLMemorySession(this.ownerId, this.memoryContainerId, this.summary, this.createdTime, this.lastUpdateTime, this.metadata, this.agents, this.additionalInfo, this.namespace, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MLMemorySession.MLMemorySessionBuilder(ownerId=" + this.ownerId + ", memoryContainerId=" + this.memoryContainerId + ", summary=" + this.summary + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", metadata=" + String.valueOf(this.metadata) + ", agents=" + String.valueOf(this.agents) + ", additionalInfo=" + String.valueOf(this.additionalInfo) + ", namespace=" + String.valueOf(this.namespace) + ", tenantId=" + this.tenantId + ")";
        }
    }
}

