/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryStrategyType;

public class MemoryStrategy
implements ToXContentObject,
Writeable {
    private String id;
    private Boolean enabled;
    private MemoryStrategyType type;
    private List<String> namespace;
    private Map<String, Object> strategyConfig;

    public MemoryStrategy(String id, Boolean enabled, MemoryStrategyType type2, List<String> namespace, Map<String, Object> strategyConfig) {
        this.id = id;
        this.enabled = enabled;
        this.type = type2;
        this.namespace = namespace;
        this.strategyConfig = strategyConfig;
    }

    public MemoryStrategy(StreamInput input) throws IOException {
        this.id = input.readString();
        this.enabled = input.readOptionalBoolean();
        this.type = input.readBoolean() ? (MemoryStrategyType)input.readEnum(MemoryStrategyType.class) : null;
        this.namespace = input.readBoolean() ? input.readStringList() : null;
        this.strategyConfig = input.readBoolean() ? input.readMap() : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalBoolean(this.enabled);
        if (this.type != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.type);
        } else {
            out.writeBoolean(false);
        }
        if (this.namespace != null) {
            out.writeBoolean(true);
            out.writeStringCollection(this.namespace);
        } else {
            out.writeBoolean(false);
        }
        if (this.strategyConfig != null && !this.strategyConfig.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.strategyConfig);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("enabled", this.enabled);
        if (this.type != null) {
            builder.field("type", this.type.getValue());
        }
        if (this.namespace != null) {
            builder.field("namespace", this.namespace);
        }
        if (this.strategyConfig != null && !this.strategyConfig.isEmpty()) {
            builder.field("configuration", this.strategyConfig);
        }
        builder.endObject();
        return builder;
    }

    public static MemoryStrategy parse(XContentParser parser) throws IOException {
        String id = null;
        Boolean enabled = null;
        MemoryStrategyType type2 = null;
        ArrayList<String> namespace = null;
        Map strategyConfig = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "id": {
                    id = parser.text();
                    continue block14;
                }
                case "enabled": {
                    enabled = parser.booleanValue();
                    continue block14;
                }
                case "type": {
                    type2 = MemoryStrategyType.fromString(parser.text());
                    continue block14;
                }
                case "namespace": {
                    namespace = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        namespace.add(parser.text());
                    }
                    continue block14;
                }
                case "configuration": {
                    strategyConfig = parser.map();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return MemoryStrategy.builder().id(id).enabled(enabled).type(type2).namespace(namespace).strategyConfig(strategyConfig).build();
    }

    public boolean isEnabled() {
        return this.enabled == null || this.enabled != false;
    }

    public static void validate(MemoryStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("Strategy cannot be null");
        }
        if (strategy.getNamespace() == null || strategy.getNamespace().isEmpty()) {
            throw new IllegalArgumentException("Strategy namespace is required. Please provide a non-empty namespace array.");
        }
    }

    public static String generateStrategyId(MemoryStrategyType type2) {
        return type2.getValue().toLowerCase() + "_" + UUID.randomUUID().toString().substring(0, 8);
    }

    @Generated
    public static MemoryStrategyBuilder builder() {
        return new MemoryStrategyBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public MemoryStrategyType getType() {
        return this.type;
    }

    @Generated
    public List<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Map<String, Object> getStrategyConfig() {
        return this.strategyConfig;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setType(MemoryStrategyType type2) {
        this.type = type2;
    }

    @Generated
    public void setNamespace(List<String> namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setStrategyConfig(Map<String, Object> strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryStrategy)) {
            return false;
        }
        MemoryStrategy other = (MemoryStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        MemoryStrategyType this$type = this.getType();
        MemoryStrategyType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$namespace = this.getNamespace();
        List<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Map<String, Object> this$strategyConfig = this.getStrategyConfig();
        Map<String, Object> other$strategyConfig = other.getStrategyConfig();
        return !(this$strategyConfig == null ? other$strategyConfig != null : !((Object)this$strategyConfig).equals(other$strategyConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoryStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Boolean $enabled = this.getEnabled();
        result2 = result2 * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $id = this.getId();
        result2 = result2 * 59 + ($id == null ? 43 : $id.hashCode());
        MemoryStrategyType $type = this.getType();
        result2 = result2 * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $namespace = this.getNamespace();
        result2 = result2 * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Map<String, Object> $strategyConfig = this.getStrategyConfig();
        result2 = result2 * 59 + ($strategyConfig == null ? 43 : ((Object)$strategyConfig).hashCode());
        return result2;
    }

    @Generated
    public static class MemoryStrategyBuilder {
        @Generated
        private String id;
        @Generated
        private Boolean enabled;
        @Generated
        private MemoryStrategyType type;
        @Generated
        private List<String> namespace;
        @Generated
        private Map<String, Object> strategyConfig;

        @Generated
        MemoryStrategyBuilder() {
        }

        @Generated
        public MemoryStrategyBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public MemoryStrategyBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public MemoryStrategyBuilder type(MemoryStrategyType type2) {
            this.type = type2;
            return this;
        }

        @Generated
        public MemoryStrategyBuilder namespace(List<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MemoryStrategyBuilder strategyConfig(Map<String, Object> strategyConfig) {
            this.strategyConfig = strategyConfig;
            return this;
        }

        @Generated
        public MemoryStrategy build() {
            return new MemoryStrategy(this.id, this.enabled, this.type, this.namespace, this.strategyConfig);
        }

        @Generated
        public String toString() {
            return "MemoryStrategy.MemoryStrategyBuilder(id=" + this.id + ", enabled=" + this.enabled + ", type=" + String.valueOf((Object)this.type) + ", namespace=" + String.valueOf(this.namespace) + ", strategyConfig=" + String.valueOf(this.strategyConfig) + ")";
        }
    }
}

