/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import java.util.List;
import java.util.stream.Collectors;

public class WildcardUtils {
    private static final String WILDCARD = "*";

    public static boolean matchesWildcardPattern(String pattern, String fieldName) {
        if (pattern == null || fieldName == null) {
            return false;
        }
        if (!WildcardUtils.containsWildcard(pattern)) {
            return pattern.equals(fieldName);
        }
        String[] compiledPattern = pattern.split("\\*", -1);
        return WildcardUtils.matchesCompiledPattern(compiledPattern, fieldName);
    }

    public static List<String> expandWildcardPattern(String pattern, List<String> availableFields) {
        if (pattern == null || availableFields == null) {
            return List.of();
        }
        if (!WildcardUtils.containsWildcard(pattern)) {
            return availableFields.stream().filter(field -> pattern.equals(field)).collect(Collectors.toList());
        }
        String[] compiledPattern = pattern.split("\\*", -1);
        return availableFields.stream().filter(field -> WildcardUtils.matchesCompiledPattern(compiledPattern, field)).collect(Collectors.toList());
    }

    private static boolean matchesCompiledPattern(String[] parts, String fieldName) {
        if (fieldName == null) {
            return false;
        }
        int startIndex = 0;
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            if (i == 0) {
                if (!fieldName.startsWith(part)) {
                    return false;
                }
                startIndex = part.length();
                continue;
            }
            int index = fieldName.indexOf(part, startIndex);
            if (index == -1) {
                return false;
            }
            startIndex = index + part.length();
        }
        String lastPart = parts[parts.length - 1];
        return lastPart.isEmpty() || fieldName.endsWith(lastPart);
    }

    public static boolean containsWildcard(String str) {
        return str != null && str.contains(WILDCARD);
    }
}

