/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning;

import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.CalcitePlanContext;

public class RangeFormatter {
    public static RexNode createRangeString(RexNode binValue, RexNode binEnd, CalcitePlanContext context) {
        return RangeFormatter.createRangeString(binValue, binEnd, null, context);
    }

    public static RexNode createRangeString(RexNode binValue, RexNode binEnd, RexNode width, CalcitePlanContext context) {
        RexLiteral dash = context.relBuilder.literal("-");
        RexNode binValueFormatted = width != null ? RangeFormatter.createFormattedValue(binValue, width, context) : context.relBuilder.cast(binValue, SqlTypeName.VARCHAR);
        RexNode binEndFormatted = width != null ? RangeFormatter.createFormattedValue(binEnd, width, context) : context.relBuilder.cast(binEnd, SqlTypeName.VARCHAR);
        RexNode firstConcat = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CONCAT, binValueFormatted, dash);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CONCAT, firstConcat, binEndFormatted);
    }

    private static RexNode createFormattedValue(RexNode value, RexNode width, CalcitePlanContext context) {
        RexNode isIntegerWidth = context.relBuilder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, width, context.relBuilder.literal(1.0));
        RexNode integerValue = context.relBuilder.cast(context.relBuilder.cast(value, SqlTypeName.INTEGER), SqlTypeName.VARCHAR);
        RexNode decimalValue = context.relBuilder.cast(value, SqlTypeName.VARCHAR);
        return context.relBuilder.call((SqlOperator)SqlStdOperatorTable.CASE, isIntegerWidth, integerValue, decimalValue);
    }
}

