/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.transport.model;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.sql.directquery.transport.model.datasource.DataSourceResult;
import org.opensearch.sql.directquery.transport.model.datasource.PrometheusResult;

public class ExecuteDirectQueryActionResponse
extends ActionResponse {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final String queryId;
    private final Map<String, DataSourceResult> results;
    private final String sessionId;

    public ExecuteDirectQueryActionResponse(String queryId, String result2, String sessionId, String dataSourceName, String dataSourceType) throws IOException {
        this.queryId = queryId;
        this.sessionId = sessionId;
        this.results = this.parseResult(result2, dataSourceName, dataSourceType);
    }

    public ExecuteDirectQueryActionResponse(StreamInput in) throws IOException {
        super(in);
        this.queryId = in.readString();
        int resultCount = in.readInt();
        this.results = new HashMap<String, DataSourceResult>(resultCount);
        for (int i = 0; i < resultCount; ++i) {
            String dataSourceId = in.readString();
            String dataSourceType = in.readString();
            String resultJson = in.readString();
            this.results.put(dataSourceId, switch (dataSourceType) {
                case "prometheus" -> AccessController.doPrivileged(() -> {
                    try {
                        return OBJECT_MAPPER.readValue(resultJson, PrometheusResult.class);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to deserialize Prometheus result", e);
                    }
                });
                default -> throw new IOException("Unsupported data source type: " + dataSourceType);
            });
        }
        this.sessionId = in.readOptionalString();
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeString(this.queryId);
        streamOutput.writeInt(this.results.size());
        for (Map.Entry<String, DataSourceResult> entry : this.results.entrySet()) {
            streamOutput.writeString(entry.getKey());
            DataSourceResult result2 = entry.getValue();
            if (!(result2 instanceof PrometheusResult)) {
                throw new IOException("Unsupported DataSourceResult type: " + result2.getClass().getName());
            }
            streamOutput.writeString("prometheus");
            String serializedResult = AccessController.doPrivileged(() -> {
                try {
                    return OBJECT_MAPPER.writeValueAsString(result2);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to serialize result", e);
                }
            });
            streamOutput.writeString(serializedResult);
        }
        streamOutput.writeOptionalString(this.sessionId);
    }

    private Map<String, DataSourceResult> parseResult(String rawResult, String dataSourceName, String dataSourceType) throws IOException {
        HashMap<String, DataSourceResult> parsedResults = new HashMap<String, DataSourceResult>();
        try {
            String resultWithType = !rawResult.contains("\"type\":") ? this.addTypeFieldToJson(rawResult, dataSourceType) : rawResult;
            DataSourceResult result2 = AccessController.doPrivileged(() -> {
                try {
                    switch (dataSourceType.toLowerCase()) {
                        case "prometheus": {
                            return OBJECT_MAPPER.readValue(resultWithType, PrometheusResult.class);
                        }
                    }
                    throw new IOException("Unsupported data source type: " + dataSourceType);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse result for data source type: " + dataSourceType, e);
                }
            });
            parsedResults.put(dataSourceName, result2);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Failed to parse result from " + dataSourceName + ": " + e.getMessage(), e);
        }
        return parsedResults;
    }

    private String addTypeFieldToJson(String rawJson, String type2) {
        return rawJson.replaceFirst("\\{", "{\"type\":\"" + type2 + "\",");
    }

    @Generated
    public ExecuteDirectQueryActionResponse(String queryId, Map<String, DataSourceResult> results, String sessionId) {
        this.queryId = queryId;
        this.results = results;
        this.sessionId = sessionId;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public Map<String, DataSourceResult> getResults() {
        return this.results;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }
}

