/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import java.util.List;
import java.util.Locale;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class SumAggregator
extends Aggregator<SumState> {
    public SumAggregator(List<Expression> arguments2, ExprCoreType returnType) {
        super(BuiltinFunctionName.SUM.getName(), arguments2, returnType);
    }

    @Override
    public SumState create() {
        return new SumState(this.returnType);
    }

    @Override
    protected SumState iterate(ExprValue value, SumState state) {
        state.isEmptyCollection = false;
        state.add(value);
        return state;
    }

    public String toString() {
        return String.format(Locale.ROOT, "sum(%s)", ExpressionUtils.format(this.getArguments()));
    }

    protected static class SumState
    implements AggregationState {
        private final ExprCoreType type;
        private ExprValue sumResult;
        private boolean isEmptyCollection;

        SumState(ExprCoreType type2) {
            this.type = type2;
            this.sumResult = ExprValueUtils.integerValue(0);
            this.isEmptyCollection = true;
        }

        public void add(ExprValue value) {
            switch (this.type) {
                case INTEGER: {
                    this.sumResult = ExprValueUtils.integerValue(ExprValueUtils.getIntegerValue(this.sumResult) + ExprValueUtils.getIntegerValue(value));
                    break;
                }
                case LONG: {
                    this.sumResult = ExprValueUtils.longValue(ExprValueUtils.getLongValue(this.sumResult) + ExprValueUtils.getLongValue(value));
                    break;
                }
                case FLOAT: {
                    this.sumResult = ExprValueUtils.floatValue(Float.valueOf(ExprValueUtils.getFloatValue(this.sumResult).floatValue() + ExprValueUtils.getFloatValue(value).floatValue()));
                    break;
                }
                case DOUBLE: {
                    this.sumResult = ExprValueUtils.doubleValue(ExprValueUtils.getDoubleValue(this.sumResult) + ExprValueUtils.getDoubleValue(value));
                    break;
                }
                default: {
                    throw new ExpressionEvaluationException(String.format("unexpected type [%s] in sum aggregation", this.type));
                }
            }
        }

        @Override
        public ExprValue result() {
            return this.isEmptyCollection ? ExprNullValue.of() : this.sumResult;
        }
    }
}

