/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.logical.node;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.legacy.domain.Field;
import org.opensearch.sql.legacy.query.planner.core.PlanNode;
import org.opensearch.sql.legacy.query.planner.logical.LogicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.PhysicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.Row;
import org.opensearch.sql.legacy.query.planner.physical.estimation.Cost;
import shaded.com.google.common.collect.HashMultimap;
import shaded.com.google.common.collect.Multimap;

public class Project<T>
implements LogicalOperator,
PhysicalOperator<T> {
    private static final Logger LOG = LogManager.getLogger();
    private final PlanNode next;
    private final Multimap<String, Field> tableAliasColumns;
    private final Map<String, String> fullNameAlias;

    public Project(PlanNode next) {
        this(next, HashMultimap.create());
    }

    public Project(PlanNode next, Multimap<String, Field> tableAliasToColumns) {
        this.next = next;
        this.tableAliasColumns = tableAliasToColumns;
        this.fullNameAlias = this.fullNameAndAlias();
    }

    @Override
    public boolean isNoOp() {
        return this.tableAliasColumns.isEmpty();
    }

    @Override
    public PlanNode[] children() {
        return new PlanNode[]{this.next};
    }

    public <U> PhysicalOperator[] toPhysical(Map<LogicalOperator, PhysicalOperator<U>> optimalOps) {
        if (!(this.next instanceof LogicalOperator)) {
            throw new IllegalStateException("Only logical operator can perform this toPhysical() operation");
        }
        return new PhysicalOperator[]{new Project<T>(optimalOps.get(this.next), this.tableAliasColumns)};
    }

    @Override
    public Cost estimate() {
        return new Cost();
    }

    @Override
    public boolean hasNext() {
        return ((PhysicalOperator)this.next).hasNext();
    }

    @Override
    public Row<T> next() {
        Row row = (Row)((PhysicalOperator)this.next).next();
        if (!this.fullNameAlias.isEmpty()) {
            row.retain(this.fullNameAlias);
        }
        LOG.trace("Projected row by fields {}: {}", this.tableAliasColumns, (Object)row);
        return row;
    }

    public void project(String tableAlias, Collection<Field> columns) {
        this.tableAliasColumns.putAll(tableAlias, columns);
    }

    public void projectAll(String tableAlias) {
        this.tableAliasColumns.put(tableAlias, new Field("*", ""));
    }

    public void forEach(BiConsumer<String, Collection<Field>> action) {
        this.tableAliasColumns.asMap().forEach(action);
    }

    public void pushDown(String tableAlias, Project<?> pushedDownProj) {
        Collection<Field> columns = pushedDownProj.tableAliasColumns.get(tableAlias);
        if (columns != null) {
            this.tableAliasColumns.putAll(tableAlias, columns);
        }
    }

    private Map<String, String> fullNameAndAlias() {
        HashMap<String, String> fullNamesAlias = new HashMap<String, String>();
        this.forEach((tableAlias, fields2) -> {
            for (Field field : fields2) {
                fullNamesAlias.put(tableAlias + "." + field.getName(), field.getAlias());
            }
        });
        return fullNamesAlias;
    }

    public String toString() {
        ArrayList<CallSite> colStrs = new ArrayList<CallSite>();
        for (Map.Entry<String, Field> entry : this.tableAliasColumns.entries()) {
            colStrs.add((CallSite)((Object)(entry.getKey() + "." + entry.getValue().getName())));
        }
        return "Project [ columns=[" + String.join((CharSequence)", ", colStrs) + "] ]";
    }
}

