/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.opensearch.storage.script.filter.lucene.relevance.RelevanceQuery;

abstract class NoFieldQuery<T extends QueryBuilder>
extends RelevanceQuery<T> {
    public NoFieldQuery(Map<String, RelevanceQuery.QueryBuilderStep<T>> queryBuildActions) {
        super(queryBuildActions);
    }

    @Override
    protected void ignoreArguments(List<NamedArgumentExpression> arguments2) {
        arguments2.removeIf(a -> a.getArgName().equalsIgnoreCase("query"));
    }

    @Override
    protected void checkValidArguments(String argNormalized, T queryBuilder) {
        if (!this.getQueryBuildActions().containsKey(argNormalized)) {
            throw new SemanticCheckException(String.format("Parameter %s is invalid for %s function.", argNormalized, this.getQueryName()));
        }
    }

    @Override
    public QueryBuilder build(FunctionExpression func) {
        List<NamedArgumentExpression> arguments2 = func.getArguments().stream().map(a -> (NamedArgumentExpression)a).collect(Collectors.toList());
        if (arguments2.size() < 1) {
            throw new SyntaxCheckException(String.format("%s requires at least one parameter", func.getFunctionName()));
        }
        return this.loadArguments(arguments2);
    }

    @Override
    public T createQueryBuilder(List<NamedArgumentExpression> arguments2) {
        NamedArgumentExpression query = arguments2.stream().filter(a -> a.getArgName().equalsIgnoreCase("query")).findFirst().orElseThrow(() -> new SemanticCheckException("'query' parameter is missing"));
        return this.createBuilder(query.getValue().valueOf().stringValue());
    }

    protected abstract T createBuilder(String var1);
}

