/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchGenerationException;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.legacy.executor.format.ErrorMessageFactory;
import org.opensearch.transport.client.Requests;
import org.opensearch.transport.client.node.NodeClient;
import shaded.com.google.common.collect.ImmutableList;

public class RestQuerySettingsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestQuerySettingsAction.class);
    private static final String PERSISTENT = "persistent";
    private static final String TRANSIENT = "transient";
    private static final String SQL_SETTINGS_PREFIX = "plugins.sql.";
    private static final String PPL_SETTINGS_PREFIX = "plugins.ppl.";
    private static final String CALCITE_SETTINGS_PREFIX = "plugins.calcite.";
    private static final String COMMON_SETTINGS_PREFIX = "plugins.query.";
    private static final String EXECUTION_ENGINE_SETTINGS_PREFIX = "plugins.query.executionengine";
    public static final String DATASOURCES_SETTINGS_PREFIX = "plugins.query.datasources";
    private static final List<String> SETTINGS_PREFIX = ImmutableList.of("plugins.sql.", "plugins.ppl.", "plugins.query.", "plugins.calcite.");
    private static final List<String> DENY_LIST_SETTINGS_PREFIX = ImmutableList.of("plugins.query.executionengine", "plugins.query.datasources");
    public static final String SETTINGS_API_ENDPOINT = "/_plugins/_query/settings";

    public RestQuerySettingsAction(Settings settings, RestController restController) {
    }

    public String getName() {
        return "ppl_settings_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of(new RestHandler.Route(RestRequest.Method.PUT, SETTINGS_API_ENDPOINT));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Map source2;
        QueryContext.addRequestId();
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = Requests.clusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.timeout(request.paramAsTime("timeout", clusterUpdateSettingsRequest.timeout()));
        clusterUpdateSettingsRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", clusterUpdateSettingsRequest.clusterManagerNodeTimeout()));
        try (XContentParser parser = request.contentParser();){
            source2 = parser.map();
        }
        try {
            if (source2.containsKey(TRANSIENT)) {
                clusterUpdateSettingsRequest.transientSettings(this.getAndFilterSettings((Map)source2.get(TRANSIENT)));
            }
            if (source2.containsKey(PERSISTENT)) {
                clusterUpdateSettingsRequest.persistentSettings(this.getAndFilterSettings((Map)source2.get(PERSISTENT)));
            }
            return channel -> client.admin().cluster().updateSettings(clusterUpdateSettingsRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (Exception e) {
            LOG.error("Error changing OpenSearch SQL plugin cluster settings", (Throwable)e);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ErrorMessageFactory.createErrorMessage(e, RestStatus.INTERNAL_SERVER_ERROR.getStatus()).toString()));
        }
    }

    private Settings getAndFilterSettings(Map<String, ?> source2) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source2);
            Settings.Builder settingsBuilder = Settings.builder().loadFromSource(builder.toString(), builder.contentType());
            settingsBuilder.keys().removeIf(key -> {
                for (String prefix : SETTINGS_PREFIX) {
                    if (!key.startsWith(prefix)) continue;
                    return false;
                }
                return true;
            });
            settingsBuilder.keys().removeIf(key -> DENY_LIST_SETTINGS_PREFIX.stream().anyMatch(key::startsWith));
            return settingsBuilder.build();
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + String.valueOf(source2) + "]", (Throwable)e);
        }
    }
}

