/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.functions.response;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.prometheus.functions.response.PrometheusFunctionResponseHandle;

public class QueryRangeFunctionResponseHandle
implements PrometheusFunctionResponseHandle {
    private final JSONObject responseObject;
    private Iterator<ExprValue> responseIterator;
    private ExecutionEngine.Schema schema;

    public QueryRangeFunctionResponseHandle(JSONObject responseObject) {
        this.responseObject = responseObject;
        this.constructSchema();
        this.constructIterator();
    }

    private void constructIterator() {
        ArrayList<ExprTupleValue> result2 = new ArrayList<ExprTupleValue>();
        if ("matrix".equals(this.responseObject.getString("resultType"))) {
            JSONArray itemArray = this.responseObject.getJSONArray("result");
            for (int i = 0; i < itemArray.length(); ++i) {
                LinkedHashMap<String, ExprValue> linkedHashMap = new LinkedHashMap<String, ExprValue>();
                JSONObject item = itemArray.getJSONObject(i);
                linkedHashMap.put("@labels", this.extractLabels(item.getJSONObject("metric")));
                QueryRangeFunctionResponseHandle.extractTimestampAndValues(item.getJSONArray("values"), linkedHashMap);
                result2.add(new ExprTupleValue(linkedHashMap));
            }
        } else {
            throw new RuntimeException(String.format("Unexpected Result Type: %s during Prometheus Response Parsing. 'matrix' resultType is expected", this.responseObject.getString("resultType")));
        }
        this.responseIterator = result2.iterator();
    }

    private static void extractTimestampAndValues(JSONArray values2, LinkedHashMap<String, ExprValue> linkedHashMap) {
        ArrayList<ExprValue> timestampList = new ArrayList<ExprValue>();
        ArrayList<ExprValue> valueList = new ArrayList<ExprValue>();
        for (int j = 0; j < values2.length(); ++j) {
            JSONArray value = values2.getJSONArray(j);
            timestampList.add(new ExprTimestampValue(Instant.ofEpochMilli((long)(value.getDouble(0) * 1000.0))));
            valueList.add(new ExprDoubleValue(value.getDouble(1)));
        }
        linkedHashMap.put("@timestamp", new ExprCollectionValue(timestampList));
        linkedHashMap.put("@value", new ExprCollectionValue(valueList));
    }

    private void constructSchema() {
        this.schema = new ExecutionEngine.Schema(this.getColumnList());
    }

    private ExprValue extractLabels(JSONObject metric) {
        LinkedHashMap<String, ExprValue> labelsMap = new LinkedHashMap<String, ExprValue>();
        metric.keySet().forEach(key -> labelsMap.put((String)key, new ExprStringValue(metric.getString((String)key))));
        return new ExprTupleValue(labelsMap);
    }

    private List<ExecutionEngine.Schema.Column> getColumnList() {
        ArrayList<ExecutionEngine.Schema.Column> columnList = new ArrayList<ExecutionEngine.Schema.Column>();
        columnList.add(new ExecutionEngine.Schema.Column("@labels", "@labels", ExprCoreType.STRUCT));
        columnList.add(new ExecutionEngine.Schema.Column("@timestamp", "@timestamp", ExprCoreType.ARRAY));
        columnList.add(new ExecutionEngine.Schema.Column("@value", "@value", ExprCoreType.ARRAY));
        return columnList;
    }

    @Override
    public boolean hasNext() {
        return this.responseIterator.hasNext();
    }

    @Override
    public ExprValue next() {
        return this.responseIterator.next();
    }

    @Override
    public ExecutionEngine.Schema schema() {
        return this.schema;
    }
}

