/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.planner.logical.rules;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.optimizer.Rule;
import org.opensearch.sql.planner.optimizer.pattern.Patterns;
import org.opensearch.sql.prometheus.planner.logical.PrometheusLogicalMetricScan;

public class MergeFilterAndRelation
implements Rule<LogicalFilter> {
    private final Capture<LogicalRelation> relationCapture = Capture.newCapture();
    private final Pattern<LogicalFilter> pattern = Pattern.typeOf(LogicalFilter.class).with(Patterns.source().matching(Pattern.typeOf(LogicalRelation.class).capturedAs(this.relationCapture)));

    @Override
    public Pattern<LogicalFilter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(LogicalFilter filter, Captures captures) {
        LogicalRelation relation = captures.get(this.relationCapture);
        return PrometheusLogicalMetricScan.builder().metricName(relation.getRelationName()).filter(filter.getCondition()).build();
    }
}

