# Greek (Farnese + Almagest)

## Introduction

This ancient Greek celestial culture is based on the marble globe of the Atlas statue in the Villa Farnese (Naples). The statue dates to the 2nd century AD, i.e. Roman times. However, it is a copy of an older Greek model, which itself has not survived.

## Description

The marble globe only depicts figures and no stars. The globe has a diameter of about 65 cm. The figures were not aligned according to exact point coordinates, but in a grid: the ecliptic, the celestial equator, the tropics and the polar circles provide orientation in terms of position in "latitude circles" on the celestial sphere, while the coluric circles provide a four-way division in "longitude circles". Ancient globe makers used this very coarse-meshed grid to adjust the figure drawings.

The images of the globe therefore clearly show that the stonemason who created the globe had the popular doctrinal poem by Aratos of Soloi (~300 BCE) in mind. There is no reason for the claim - often inflated by popular science - that this marble globe was carved according to Hipparchus' star catalogue. This thesis has been repeatedly raised over the past ~200 years, but regularly dismissed: Both mathematical arguments and artistic representations speak against it.

<p><img width="800" src="illustrations/Atlas_(Farnese_Globe).jpg"/></p>
<p><i>Photograph of the reconstructed statue of the Atlas Farnese (Gabriel Seah, CC BY-SA-3.0, 9. Juli 2006, Museo Archeologico Nazionale, Naples).</i></p>

Only the torso of the man was preserved and with broken elbows: everything below the hip has been supplemented in a modern way. In this form, the sculpture is 2.10 m high. The sculpture of the globe with constellations, which is important for us, is original, but has a large hole at the north pole - presumably it was anchored there to other parts of the architecture. Therefore, the circumpolar constellations of the two she-bears and parts of the dragon are missing.

### How was this Sky Culture made?

The illustrations of the individual figures were copied from the marble globe as pencil sketches. Stellarium works with point coordinates of the modern HIPPARCOS catalogue (produced by an astrometry satellite), so that the historical drawings have to be locked at three points (stars) each. Since this sometimes leads to distortions in historical figures (the marble globe is not a perfect sphere, the figures were not fitted according to point coordinates), this was done here "by eye" - just as by the historical stonemason.

The names of the constellations and individual stars were taken from the Almagest star catalogue, which also dates from the 2nd century (i.e. the reign of the Roman Emperor Hadrian) and - as was customary at the time - was written in Greek as scientific literature.

The marble globe was a decorative element in a building, probably a particularly elaborate capital. It has no scientific accuracy. Therefore, some drawings in relief deviate from the exact star positions of the star catalogue: e.g. the Twins (Gemini) are moved slightly to the side to show the figure completely, although the lower part of this celestial region would be covered by the hand of the Atlas statue. There are similar distortions in the Scorpion.

The following table lists the original Greek names of the constellations in columns 2 and 3, and in column 4 the image on the globe.

<p>
<table>
	<tr valign="top">
		<td><b>Abbreviation</b></td>
		<td><b>Original Name</b></td>
		<td><b>Translation</b> (literally)</td>
		<td><b>Picture</b></td>
	</tr>
	<tr valign="top">
		<td><notr>UMi</notr></td>
		<td><notr>&Mu;&iota;&kappa;&rho;&#942; &#702;&#714;&Alpha;&rho;&kappa;&tau;&omicron;&sigmaf;</notr></td>
		<td>Little She-Bear</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>UMa</notr></td>
		<td><notr>&Mu;&epsilon;&gamma;&alpha;&lambda;&#942; &#702;&#714;&Alpha;&rho;&kappa;&tau;&omicron;&sigmaf;</notr></td>
		<td>Great She-Bear</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Dra</notr></td>
		<td><notr>&Delta;&rho;&#940;&kappa;&omega;&nu;</notr></td>
		<td>Dragon</td>
		<td>only the head and one bend are depicted<br /><img width="255" src="illustrations/dra_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cep</notr></td>
		<td><notr>&Kappa;&eta;&phi;&epsilon;&#973;&sigmaf;</notr></td>
		<td>King Kepheus</td>
		<td><img width="255" src="illustrations/cep_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Boo</notr></td>
		<td><notr>&Beta;&omicron;&#974;&tau;&eta;&sigmaf;</notr></td>
		<td>Ploughing Man</td>
		<td><img width="255" src="illustrations/boo_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>CrB</notr></td>
		<td><notr>&Sigma;&tau;&#941;&phi;&alpha;&nu;&omicron;&sigmaf;</notr></td>
		<td>Wreath</td>
		<td><img width="255" src="illustrations/crb_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Her</notr></td>
		<td><notr>&#702;&Epsilon;&nu;&gamma;&#972;&nu;&alpha;&sigma;&iota;&nu;</notr></td>
		<td>Kneeler</td>
		<td><img width="255" src="illustrations/her_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Lyr</notr></td>
		<td><notr>&Lambda;&#973;&rho;&alpha;</notr></td>
		<td>Lyre (a Greek instrument)</td>
		<td><img width="255" src="illustrations/lyr_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cyg</notr></td>
		<td><notr>&#702;&#714;&Omicron;&rho;&nu;&iota;&sigmaf;</notr></td>
		<td>Bird [not specified]</td>
		<td><img width="255" src="illustrations/cyg_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cas</notr></td>
		<td><notr>&Kappa;&alpha;&sigma;&sigma;&iota;&#941;&pi;&epsilon;&iota;&alpha;</notr></td>
		<td>Queen Kassiepeia</td>
		<td><img width="255" src="illustrations/cas_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Per</notr></td>
		<td><notr>&Pi;&epsilon;&rho;&sigma;&epsilon;&#973;&sigmaf;</notr></td>
		<td>Perseus</td>
		<td><img width="255" src="illustrations/per_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Aur</notr></td>
		<td><notr>&#703;&Eta;&nu;&#943;&omicron;&chi;&omicron;&sigmaf;</notr></td>
		<td>Charioteer</td>
		<td><img width="255" src="illustrations/aur_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Oph + Ser</notr></td>
		<td><notr>&#702;&Omicron;&phi;&iota;&omicron;&#973;&chi;&omicron;&sigmaf; + &#702;&#714;&Omicron;&phi;&iota;&sigmaf;</notr></td>
		<td>Snake Carrier, Snake</td>
		<td><img width="255" src="illustrations/oph_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Sge</notr></td>
		<td><notr>&#702;&Omicron;&iota;&sigma;&tau;&#972;&sigmaf;</notr></td>
		<td>Arrow</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Aql</notr></td>
		<td><notr>&#702;&Alpha;&epsilon;&tau;&#972;&sigmaf;</notr></td>
		<td>Eagle</td>
		<td><img width="255" src="illustrations/aql_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Del</notr></td>
		<td><notr>&Delta;&epsilon;&lambda;&phi;&#943;&sigmaf;</notr></td>
		<td>Dolphin</td>
		<td><img width="255" src="illustrations/del_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Equ</notr></td>
		<td><notr>&Pi;&rho;&omicron;&tau;&omicron;&mu;&#942;</notr></td>
		<td>Bust [of a horse]</td>
		<td>missing (stars belong to Dolphin)</td>
	</tr>
	<tr valign="top">
		<td><notr>Peg</notr></td>
		<td><notr>&#703;&#714;&Iota;&pi;&pi;&omicron;&sigmaf;</notr></td>
		<td>Horse [unnamed]</td>
		<td><img width="255" src="illustrations/peg_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>And</notr></td>
		<td><notr>&#702;&Alpha;&nu;&delta;&rho;&omicron;&mu;&#941;&delta;&alpha;</notr></td>
		<td>Princess Andromeda</td>
		<td><img width="355" src="illustrations/and_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Tri</notr></td>
		<td><notr>&Tau;&rho;&#943;&gamma;&omega;&nu;&omicron;&sigmaf;</notr></td>
		<td>Triangle</td>
		<td>missing</td>
	</tr>
	<tr valign="top">
		<td><notr>Ari</notr></td>
		<td><notr>&Kappa;&rho;&iota;&#972;&sigmaf;</notr></td>
		<td>Ram</td>
		<td><img width="255" src="illustrations/ari_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Tau</notr></td>
		<td><notr>&Tau;&alpha;&upsilon;&#771;&rho;&omicron;&sigmaf;</notr></td>
		<td>Bull</td>
		<td><img width="255" src="illustrations/tau_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Gem</notr></td>
		<td><notr>&Delta;&#943;&delta;&upsilon;&mu;&omicron;&iota;</notr></td>
		<td>Twins</td>
		<td><img width="255" src="illustrations/gem_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cnc</notr></td>
		<td><notr>&Kappa;&alpha;&rho;&kappa;&#943;&nu;&omicron;&sigmaf;</notr></td>
		<td>Cancer</td>
		<td><img width="255" src="illustrations/cnc_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Leo</notr></td>
		<td><notr>&Lambda;&#941;&omega;&nu;</notr></td>
		<td>Lion</td>
		<td><img width="255" src="illustrations/leo_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Vir</notr></td>
		<td><notr>&Pi;&alpha;&rho;&theta;&#941;&nu;&omicron;&sigmaf;</notr></td>
		<td>Young Lady</td>
		<td><img width="255" src="illustrations/vir_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Lib</notr></td>
		<td><notr>&Chi;&eta;&lambda;&alpha;&#943;</notr></td>
		<td>Claws [of the Scorpion carrying a Balance]</td>
		<td><img width="255" src="illustrations/lib.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Sco</notr></td>
		<td><notr>&Sigma;&kappa;&omicron;&rho;&pi;&#943;&omicron;&sigmaf;</notr></td>
		<td>Scorpion</td>
		<td><img width="255" src="illustrations/sco_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Sgr</notr></td>
		<td><notr>&Tau;&omicron;&xi;&#972;&tau;&eta;&sigmaf;</notr></td>
		<td>Archer (two legs: this is satyr Kroton, not the centaur Cheiron)</td>
		<td><img width="255" src="illustrations/sgr_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cap</notr></td>
		<td><notr>&Alpha;&#943;&gamma;&#972;&kappa;&epsilon;&rho;&omicron;&sigmaf;</notr></td>
		<td>the One with Horns of a Goat</td>
		<td><img width="255" src="illustrations/cap.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Aqr</notr></td>
		<td><notr>&#703;&Upsilon;&delta;&rho;&omicron;&chi;&#972;&omicron;&sigmaf;</notr></td>
		<td>Water-Pourer</td>
		<td><img width="255" src="illustrations/aqr_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Psc</notr></td>
		<td><notr>&#702;&Iota;&chi;&theta;&#973;&epsilon;&sigmaf;</notr></td>
		<td>Two Fishes</td>
		<td><img width="255" src="illustrations/psc_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cet</notr></td>
		<td><notr>&Kappa;&eta;&#771;&tau;&omicron;&sigmaf;</notr></td>
		<td>Sea Monster</td>
		<td><img width="255" src="illustrations/cet_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Ori</notr></td>
		<td><notr>&#702;&Omega;&rho;&#943;&omega;&nu;</notr></td>
		<td>Orion</td>
		<td><img width="255" src="illustrations/ori_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Eri</notr></td>
		<td><notr>&Pi;&omicron;&tau;&alpha;&mu;&#972;&sigmaf;</notr></td>
		<td>River [unnamed]</td>
		<td><img width="255" src="illustrations/eri.png"/></td>
	</tr>
	<tr>
		<td><notr>Lep</notr></td>
		<td><notr>&Lambda;&alpha;&gamma;&omega;&#771;&sigmaf;</notr></td>
		<td>Hare</td>
		<td><img width="255" src="illustrations/lep_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>CMa</notr></td>
		<td><notr>&Kappa;&#973;&omega;&nu;</notr></td>
		<td>Dog</td>
		<td><img width="255" src="illustrations/cma_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>CMi</notr></td>
		<td><notr>&Pi;&rho;&omicron;&kappa;&#973;&omega;&nu;</notr></td>
		<td>The asterism before the Dog</td>
		<td>missing [covered by the hand of Atlas]</td>
	</tr>
	<tr valign="top">
		<td><notr>Arg</notr></td>
		<td><notr>&#702;&Alpha;&rho;&gamma;&omega;</notr></td>
		<td>Ship &quot;Argo&quot;</td>
		<td><img width="255" src="illustrations/arg_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Hya + Crt + Crv</notr></td>
		<td><notr>&#703;&#714;&Upsilon;&delta;&rho;&omicron;&sigmaf; + &Kappa;&rho;&alpha;&tau;&#942;&rho; + &Kappa;&oacute;&rho;&alpha;&xi;</notr></td>
		<td>Watersnake + Crater + Raven</td>
		<td><img width="255" src="illustrations/hya_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Cen</notr></td>
		<td><notr>&Kappa;&#941;&nu;&tau;&alpha;&upsilon;&rho;&omicron;&sigmaf;</notr></td>
		<td>Kentauros</td>
		<td><img width="255" src="illustrations/cen_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Lup</notr></td>
		<td><notr>&Theta;&eta;&rho;&#943;&omicron;&nu;</notr></td>
		<td>Monster</td>
		<td><img width="255" src="illustrations/lup_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>Ara</notr></td>
		<td><notr>&Theta;&upsilon;&mu;&iota;&alpha;&tau;&#942;&rho;&iota;&omicron;&nu;</notr></td>
		<td>Altar</td>
		<td><img width="255" src="illustrations/ara_sw_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>CrA</notr></td>
		<td><notr>&Sigma;&tau;&#941;&phi;&alpha;&nu;&omicron;&sigmaf; &Nu;&#972;&tau;&iota;&omicron;&sigmaf;</notr></td>
		<td>Southern Wreath</td>
		<td><img width="255" src="illustrations/cra_bg.png"/></td>
	</tr>
	<tr valign="top">
		<td><notr>PsA</notr></td>
		<td><notr>&Nu;&#972;&tau;&iota;&omicron;&sigmaf; &#702;&Iota;&chi;&theta;&#973;&sigmaf;</notr></td>
		<td>Southern Fish</td>
		<td>missing [covered by the shoulder of Atlas]</td>
	</tr>
</table></p>

### Fair Use

We provide this sky culture free of charge, but the authors deserve to be cited according to the usual rules. Thank you!

## References

 - [#1]: Heiberg, J. L. (Ed.): Claudii Ptolemaei: Syntaxis Mathematica, Teubner, Leipzig, 1898
 - [#2]: Hoffmann, S. M.: Hipparchs Himmelsglobus, Springer, Wiesbaden/ New York, 2017
 - [#3]: Toomer, G. J.: Ptolemy's Almagest, Duckworth, London, 1984

## Authors

This sky culture was contributed to Stellarium by Susanne M. Hoffmann (service@uhura-uraniae.com).

Written in English: the author.

## License

CC BY-ND 4.0
