/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TokenRegister;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsCatLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.NewGlossaryEntry;
import java.io.IOException;

public class NewAcronym
extends NewGlossaryEntry {
    protected boolean isAbbrv;

    public NewAcronym(GlossariesSty glossariesSty) {
        this("newacronym", Overwrite.FORBID, glossariesSty);
    }

    public NewAcronym(String string, GlossariesSty glossariesSty) {
        this(string, Overwrite.FORBID, glossariesSty);
    }

    public NewAcronym(String string, Overwrite overwrite, GlossariesSty glossariesSty) {
        this(string, overwrite, glossariesSty, glossariesSty.isExtra() && string.endsWith("abbreviation"));
    }

    public NewAcronym(String string, Overwrite overwrite, GlossariesSty glossariesSty, boolean bl) {
        super(string, overwrite, glossariesSty);
        this.isAbbrv = bl;
    }

    @Override
    public Object clone() {
        return new NewAcronym(this.getName(), this.overwrite, this.getSty(), this.isAbbrv);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        TeXObject teXObject;
        TeXObject teXObject2;
        TeXObject teXObject3;
        TeXObject teXObject4;
        String string;
        KeyValList keyValList = TeXParserUtils.popOptKeyValList(teXParser, teXObjectList);
        String string2 = this.popLabelString(teXParser, teXObjectList);
        if (keyValList == null) {
            keyValList = new KeyValList();
        }
        if (this.sty.isExtra()) {
            teXParser.putControlSequence(true, new GenericCommand("ExtraCustomAbbreviationFields"));
        }
        TeXObject teXObject5 = this.popArg(teXParser, teXObjectList);
        TeXObject teXObject6 = this.popArg(teXParser, teXObjectList);
        String string3 = string = this.isAbbrv ? "abbreviation" : "acronym";
        if (this.sty.isExtra()) {
            teXObject4 = (TeXObject)keyValList.get("category");
            if (teXObject4 != null && !teXObject4.isEmpty()) {
                string = teXParser.expandToString(teXObject4, teXObjectList);
            }
            teXObject3 = new GlsCatLabel("glscategorylabel", string);
            teXParser.putControlSequence(true, (ControlSequence)teXObject3);
            keyValList.put("category", teXObject3);
        }
        keyValList.put("short", teXObject5);
        keyValList.put("long", teXObject6);
        teXObject4 = teXParser.getSettings().getTokenRegister("glslabeltok");
        ((TokenRegister)teXObject4).setContents(teXParser, teXParser.getListener().createString(string2));
        teXObject4 = teXParser.getSettings().getTokenRegister("glsshorttok");
        ((TokenRegister)teXObject4).setContents(teXParser, (TeXObject)teXObject5.clone());
        teXObject4 = teXParser.getSettings().getTokenRegister("glslongtok");
        ((TokenRegister)teXObject4).setContents(teXParser, (TeXObject)teXObject6.clone());
        if (this.sty.isExtra()) {
            this.setCurrentAbbreviationStyle(string, teXParser, teXObjectList);
        }
        if (this.sty.isExtra()) {
            teXObject3 = teXParser.getListener().getControlSequence("glsxtrnewabbrevpresetkeyhook");
            if (teXObjectList == teXParser || teXObjectList == null) {
                teXObject2 = teXParser.getListener().createGroup();
                ((TeXObjectList)teXObject2).add((TeXObject)teXObject6.clone());
                teXParser.push(teXObject2);
                teXObject2 = teXParser.getListener().createGroup();
                ((TeXObjectList)teXObject2).add((TeXObject)teXObject5.clone());
                teXParser.push(teXObject2);
                teXParser.push(teXParser.getListener().createGroup(string2));
                teXObject3.process(teXParser);
            } else {
                teXObject2 = teXParser.getListener().createGroup();
                ((TeXObjectList)teXObject2).add((TeXObject)teXObject6.clone());
                teXObjectList.push(teXObject2);
                teXObject2 = teXParser.getListener().createGroup();
                ((TeXObjectList)teXObject2).add((TeXObject)teXObject5.clone());
                teXObjectList.push(teXObject2);
                teXObjectList.push(teXParser.getListener().createGroup(string2));
                teXObject3.process(teXParser, teXObjectList);
            }
        }
        if ((teXObject3 = (TeXObject)keyValList.get("shortplural")) == null) {
            teXObject2 = teXParser.getListener().createStack();
            ((TeXObjectList)teXObject2).add((TeXObject)teXObject5.clone(), true);
            if (this.sty.isExtra()) {
                if (!this.sty.isAttributeTrue(string, "noshortplural")) {
                    if (this.sty.isAttributeTrue(string, "aposplural")) {
                        ((TeXObjectList)teXObject2).add(teXParser.getListener().getOther(8217));
                        ((TeXObjectList)teXObject2).add(new TeXCsRef("abbrvpluralsuffix"));
                    } else {
                        ((TeXObjectList)teXObject2).add(new TeXCsRef("abbrvpluralsuffix"));
                    }
                }
            } else {
                ((TeXObjectList)teXObject2).add(new TeXCsRef("acrpluralsuffix"));
            }
            keyValList.put("shortplural", teXObject2);
            teXObject3 = teXObject2;
        }
        if (this.sty.isExtra()) {
            teXObject4 = teXParser.getSettings().getTokenRegister("glsshortpltok");
            ((TokenRegister)teXObject4).setContents(teXParser, (TeXObject)teXObject3.clone());
        }
        if ((teXObject2 = (TeXObject)keyValList.get("longplural")) == null) {
            teXObject = teXParser.getListener().createStack();
            ((TeXObjectList)teXObject).add((TeXObject)teXObject6.clone(), true);
            ((TeXObjectList)teXObject).add(new TeXCsRef("glspluralsuffix"));
            keyValList.put("longplural", teXObject);
            teXObject2 = teXObject;
        }
        if (this.sty.isExtra()) {
            teXObject4 = teXParser.getSettings().getTokenRegister("glslongpltok");
            ((TokenRegister)teXObject4).setContents(teXParser, (TeXObject)teXObject2.clone());
        }
        if (keyValList.get("type") == null) {
            if (this.isAbbrv) {
                keyValList.put("type", new TeXCsRef("glsxtrabbrvtype"));
            } else {
                keyValList.put("type", new TeXCsRef("acronymtype"));
            }
        }
        if (this.sty.isExtra()) {
            teXObject = teXParser.getListener().getControlSequence("newabbreviationhook");
            if (teXObjectList == teXParser || teXObjectList == null) {
                teXObject.process(teXParser);
            } else {
                teXObject.process(teXParser, teXObjectList);
            }
        }
        if ((teXObject = (TeXObject)keyValList.get("name")) == null) {
            keyValList.put("name", (TeXObject)teXObject5.clone());
        }
        if (this.sty.isExtra()) {
            KeyValList keyValList2;
            object = teXParser.getListener().getControlSequence("CustomAbbreviationFields");
            if (object instanceof KeyValList) {
                keyValList2 = (KeyValList)object;
            } else {
                object = TeXParserUtils.expandFully((TeXObject)object, teXParser, teXObjectList);
                keyValList2 = KeyValList.getList(teXParser, (TeXObject)object);
            }
            keyValList.putAll(keyValList2);
            object = teXParser.getListener().getControlSequence("ExtraCustomAbbreviationFields");
            if (object instanceof KeyValList) {
                keyValList2 = (KeyValList)object;
            } else {
                object = TeXParserUtils.expandFully((TeXObject)object, teXParser, teXObjectList);
                keyValList2 = KeyValList.getList(teXParser, (TeXObject)object);
            }
            keyValList.putAll(keyValList2);
        } else {
            KeyValList keyValList3;
            object = teXParser.getListener().getControlSequence("GenericAcronymFields");
            if (object instanceof KeyValList) {
                keyValList3 = (KeyValList)object;
            } else {
                object = TeXParserUtils.expandFully((TeXObject)object, teXParser, teXObjectList);
                keyValList3 = KeyValList.getList(teXParser, (TeXObject)object);
            }
            keyValList.putAll(keyValList3);
        }
        this.defineEntry(string2, keyValList, teXParser, teXObjectList);
        object = teXParser.expandToString((TeXObject)keyValList.get("type"), teXObjectList);
        this.sty.declareAbbreviationGlossary((String)object);
        if (this.sty.isExtra()) {
            this.sty.addInnerFmtExclusion(string2, "first");
            this.sty.addInnerFmtExclusion(string2, "firstplural");
            this.sty.addInnerFmtExclusion(string2, "text");
            this.sty.addInnerFmtExclusion(string2, "plural");
            this.sty.addInnerFmtExclusion(string2, "name");
            ControlSequence controlSequence = teXParser.getListener().getControlSequence("GlsXtrPostNewAbbreviation");
            if (teXObjectList == teXParser || teXObjectList == null) {
                controlSequence.process(teXParser);
            } else {
                controlSequence.process(teXParser, teXObjectList);
            }
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

