﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/artifact/Artifact_EXPORTS.h>
#include <aws/artifact/model/AccountSettings.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Artifact {
namespace Model {
class GetAccountSettingsResult {
 public:
  AWS_ARTIFACT_API GetAccountSettingsResult() = default;
  AWS_ARTIFACT_API GetAccountSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ARTIFACT_API GetAccountSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const AccountSettings& GetAccountSettings() const { return m_accountSettings; }
  template <typename AccountSettingsT = AccountSettings>
  void SetAccountSettings(AccountSettingsT&& value) {
    m_accountSettingsHasBeenSet = true;
    m_accountSettings = std::forward<AccountSettingsT>(value);
  }
  template <typename AccountSettingsT = AccountSettings>
  GetAccountSettingsResult& WithAccountSettings(AccountSettingsT&& value) {
    SetAccountSettings(std::forward<AccountSettingsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetAccountSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  AccountSettings m_accountSettings;

  Aws::String m_requestId;
  bool m_accountSettingsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Artifact
}  // namespace Aws
