/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.CacheWindowScope;
import androidx.compose.foundation.lazy.layout.LazyLayoutPrefetchState;
import androidx.compose.foundation.pager.MeasuredPage;
import androidx.compose.foundation.pager.PagerLayoutInfoKt;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.ui.unit.Density;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\u00042\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002000/H\u0016J\u0010\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0004H\u0016J\u0010\u00105\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0004H\u0016J\u0010\u00106\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004H\u0016J\b\u00107\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017R\u0014\u0010\u001e\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0017R\u0014\u0010 \u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0017R\u0014\u0010$\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0017R\u0016\u0010&\u001a\u0004\u0018\u00010'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u00101\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0017\u00a8\u00068"}, d2={"Landroidx/compose/foundation/pager/PagerCacheWindowScope;", "Landroidx/compose/foundation/lazy/layout/CacheWindowScope;", "itemCount", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getItemCount", "()Lkotlin/jvm/functions/Function0;", "layoutInfo", "Landroidx/compose/foundation/pager/PagerMeasureResult;", "getLayoutInfo", "()Landroidx/compose/foundation/pager/PagerMeasureResult;", "setLayoutInfo", "(Landroidx/compose/foundation/pager/PagerMeasureResult;)V", "state", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "getState", "()Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;", "setState", "(Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState;)V", "totalItemsCount", "getTotalItemsCount", "()I", "hasVisibleItems", "", "getHasVisibleItems", "()Z", "mainAxisExtraSpaceStart", "getMainAxisExtraSpaceStart", "mainAxisExtraSpaceEnd", "getMainAxisExtraSpaceEnd", "firstVisibleLineIndex", "getFirstVisibleLineIndex", "lastVisibleLineIndex", "getLastVisibleLineIndex", "mainAxisViewportSize", "getMainAxisViewportSize", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "schedulePrefetch", "", "Landroidx/compose/foundation/lazy/layout/LazyLayoutPrefetchState$PrefetchHandle;", "lineIndex", "onItemPrefetched", "Lkotlin/Function2;", "", "visibleLineCount", "getVisibleLineCount", "getVisibleItemSize", "indexInVisibleLines", "getVisibleItemLine", "getLastIndexInLine", "getLastLineIndex", "foundation"})
final class PagerCacheWindowScope
implements CacheWindowScope {
    @NotNull
    private final Function0<Integer> itemCount;
    public PagerMeasureResult layoutInfo;
    public LazyLayoutPrefetchState state;

    public PagerCacheWindowScope(@NotNull Function0<Integer> itemCount) {
        Intrinsics.checkNotNullParameter(itemCount, (String)"itemCount");
        this.itemCount = itemCount;
    }

    @NotNull
    public final Function0<Integer> getItemCount() {
        return this.itemCount;
    }

    @NotNull
    public final PagerMeasureResult getLayoutInfo() {
        PagerMeasureResult pagerMeasureResult = this.layoutInfo;
        if (pagerMeasureResult != null) {
            return pagerMeasureResult;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutInfo");
        return null;
    }

    public final void setLayoutInfo(@NotNull PagerMeasureResult pagerMeasureResult) {
        Intrinsics.checkNotNullParameter((Object)pagerMeasureResult, (String)"<set-?>");
        this.layoutInfo = pagerMeasureResult;
    }

    @NotNull
    public final LazyLayoutPrefetchState getState() {
        LazyLayoutPrefetchState lazyLayoutPrefetchState = this.state;
        if (lazyLayoutPrefetchState != null) {
            return lazyLayoutPrefetchState;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        return null;
    }

    public final void setState(@NotNull LazyLayoutPrefetchState lazyLayoutPrefetchState) {
        Intrinsics.checkNotNullParameter((Object)lazyLayoutPrefetchState, (String)"<set-?>");
        this.state = lazyLayoutPrefetchState;
    }

    @Override
    public int getTotalItemsCount() {
        return ((Number)this.itemCount.invoke()).intValue();
    }

    @Override
    public boolean getHasVisibleItems() {
        return !((Collection)this.getLayoutInfo().getVisiblePagesInfo()).isEmpty();
    }

    @Override
    public int getMainAxisExtraSpaceStart() {
        MeasuredPage firstVisibleItem = (MeasuredPage)CollectionsKt.first(this.getLayoutInfo().getVisiblePagesInfo());
        int firstItemOverflowOffset = RangesKt.coerceAtMost((int)(firstVisibleItem.getOffset() + this.getLayoutInfo().getBeforeContentPadding()), (int)0);
        return Math.abs(firstItemOverflowOffset);
    }

    @Override
    public int getMainAxisExtraSpaceEnd() {
        MeasuredPage lastVisibleItem = (MeasuredPage)CollectionsKt.last(this.getLayoutInfo().getVisiblePagesInfo());
        int lastItemOverflowOffset = lastVisibleItem.getOffset() + this.getLayoutInfo().getPageSize() + this.getLayoutInfo().getPageSpacing();
        return Math.abs(lastItemOverflowOffset - this.getLayoutInfo().getViewportEndOffset());
    }

    @Override
    public int getFirstVisibleLineIndex() {
        long itemIndex = (long)((MeasuredPage)CollectionsKt.first(this.getLayoutInfo().getVisiblePagesInfo())).getIndex() - (long)this.getLayoutInfo().getBeyondViewportPageCount();
        return (int)RangesKt.coerceAtLeast((long)itemIndex, (long)0L);
    }

    @Override
    public int getLastVisibleLineIndex() {
        long itemIndex = (long)((MeasuredPage)CollectionsKt.last(this.getLayoutInfo().getVisiblePagesInfo())).getIndex() + (long)this.getLayoutInfo().getBeyondViewportPageCount();
        return (int)RangesKt.coerceAtMost((long)itemIndex, (long)((long)this.getTotalItemsCount() - 1L));
    }

    @Override
    public int getMainAxisViewportSize() {
        return PagerLayoutInfoKt.getMainAxisViewportSize(this.getLayoutInfo());
    }

    @Override
    @Nullable
    public Density getDensity() {
        return this.getLayoutInfo().getDensity();
    }

    @Override
    @NotNull
    public List<LazyLayoutPrefetchState.PrefetchHandle> schedulePrefetch(int lineIndex, @NotNull Function2<? super Integer, ? super Integer, Unit> onItemPrefetched) {
        Intrinsics.checkNotNullParameter(onItemPrefetched, (String)"onItemPrefetched");
        long childConstraints = this.getLayoutInfo().getChildConstraints-msEJaDk();
        return CollectionsKt.listOf((Object)this.getState().schedulePrecompositionAndPremeasure-_EkL_-Y$foundation(lineIndex, childConstraints, true, (Function1<? super LazyLayoutPrefetchState.PrefetchResultScope, Unit>)((Function1)arg_0 -> PagerCacheWindowScope.schedulePrefetch$lambda$0(onItemPrefetched, this, arg_0))));
    }

    @Override
    public int getVisibleLineCount() {
        return this.getLayoutInfo().getExtraPagesBefore().size() + this.getLayoutInfo().getVisiblePagesInfo().size() + this.getLayoutInfo().getExtraPagesAfter().size();
    }

    @Override
    public int getVisibleItemSize(int indexInVisibleLines) {
        return this.getLayoutInfo().getPageSize();
    }

    @Override
    public int getVisibleItemLine(int indexInVisibleLines) {
        int extraPagesBeforeCount = this.getLayoutInfo().getExtraPagesBefore().size();
        int visiblePagesCount = this.getLayoutInfo().getVisiblePagesInfo().size();
        if (indexInVisibleLines < extraPagesBeforeCount) {
            return this.getLayoutInfo().getExtraPagesBefore().get(indexInVisibleLines).getIndex();
        }
        if (indexInVisibleLines >= extraPagesBeforeCount && indexInVisibleLines < extraPagesBeforeCount + visiblePagesCount) {
            return this.getLayoutInfo().getVisiblePagesInfo().get(indexInVisibleLines - extraPagesBeforeCount).getIndex();
        }
        if (indexInVisibleLines >= extraPagesBeforeCount + visiblePagesCount) {
            return this.getLayoutInfo().getExtraPagesAfter().get(indexInVisibleLines - extraPagesBeforeCount - visiblePagesCount).getIndex();
        }
        return -1;
    }

    @Override
    public int getLastIndexInLine(int lineIndex) {
        return lineIndex;
    }

    @Override
    public int getLastLineIndex() {
        if (this.getTotalItemsCount() == 0) {
            return -1;
        }
        return this.getTotalItemsCount() - 1;
    }

    private static final Unit schedulePrefetch$lambda$0(Function2 $onItemPrefetched, PagerCacheWindowScope this$0, LazyLayoutPrefetchState.PrefetchResultScope $this$schedulePrecompositionAndPremeasure) {
        Intrinsics.checkNotNullParameter((Object)$this$schedulePrecompositionAndPremeasure, (String)"$this$schedulePrecompositionAndPremeasure");
        $onItemPrefetched.invoke((Object)$this$schedulePrecompositionAndPremeasure.getIndex(), (Object)this$0.getLayoutInfo().getPageSize());
        return Unit.INSTANCE;
    }
}

