/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.PathCustomizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PathManager {
    public static final String PROPERTIES_FILE = "idea.properties.file";
    public static final String PROPERTIES_FILE_NAME = "idea.properties";
    public static final String PROPERTY_HOME_PATH = "idea.home.path";
    public static final String PROPERTY_CONFIG_PATH = "idea.config.path";
    public static final String PROPERTY_SYSTEM_PATH = "idea.system.path";
    public static final String PROPERTY_SCRATCH_PATH = "idea.scratch.path";
    public static final String PROPERTY_PLUGINS_PATH = "idea.plugins.path";
    public static final String PROPERTY_LOG_PATH = "idea.log.path";
    public static final String PROPERTY_LOG_CONFIG_FILE = "idea.log.config.properties.file";
    public static final String PROPERTY_PATHS_SELECTOR = "idea.paths.selector";
    public static final String SYSTEM_PATHS_CUSTOMIZER = "idea.paths.customizer";
    public static final String OPTIONS_DIRECTORY = "options";
    public static final String DEFAULT_EXT = ".xml";
    private static final String PROPERTY_HOME = "idea.home";
    private static final String PROPERTY_VENDOR_NAME = "idea.vendor.name";
    private static final String JRE_DIRECTORY = "jbr";
    private static final String LIB_DIRECTORY = "lib";
    private static final String PLUGINS_DIRECTORY = "plugins";
    private static final String BIN_DIRECTORY = "bin";
    private static final String LOG_DIRECTORY = "log";
    private static final String CONFIG_DIRECTORY = "config";
    private static final String SYSTEM_DIRECTORY = "system";
    private static final String COMMUNITY_MARKER = "intellij.idea.community.main.iml";
    private static final String ULTIMATE_MARKER = ".ultimate.root.marker";
    private static final String PRODUCT_INFO_JSON = "product-info.json";
    private static volatile Path ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static Path ourCommonDataPath;
    private static String ourPathSelector;
    private static Path ourConfigPath;
    private static Path ourSystemPath;
    private static Path ourScratchPath;
    private static Path ourPluginPath;
    private static Path ourLogPath;
    private static Path ourStartupScriptDir;
    private static Path ourOriginalConfigDir;
    private static Path ourOriginalSystemDir;
    private static Path ourOriginalLogDir;

    private PathManager() {
    }

    @NotNull
    public static Path getHomeDir() {
        Path path = PathManager.getHomeDir(true);
        if (path == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getHomePath() {
        String string = PathManager.getHomeDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @ApiStatus.Obsolete
    public static String getHomePath(boolean insideIde) {
        Path homeDir = PathManager.getHomeDir(insideIde);
        return homeDir != null ? homeDir.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static Path getHomeDir(boolean insideIde) {
        Path result = ourHomePath;
        if (result != null) {
            return result;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result = ourHomePath;
            if (result != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result;
            }
            Path explicit = PathManager.getExplicitPath(PROPERTY_HOME_PATH);
            if (explicit == null) {
                explicit = PathManager.getExplicitPath(PROPERTY_HOME);
            }
            if (explicit != null) {
                result = explicit;
                if (!Files.isDirectory(result, new LinkOption[0])) {
                    ourHomePath = result;
                    throw new RuntimeException("Invalid home path '" + result + "'");
                }
            } else if (insideIde && (result = PathManager.getHomeDirFor(PathManager.class)) == null) {
                String advice = OS.CURRENT == OS.macOS ? "reinstall the software." : "make sure product-info.json is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result != null && OS.CURRENT == OS.Windows) {
                try {
                    result = result.toRealPath(LinkOption.NOFOLLOW_LINKS);
                }
                catch (IOException advice) {
                    // empty catch block
                }
            }
            if (result == null) {
                ourBinDirectories = Collections.emptyList();
            } else {
                Path root = result;
                if (Boolean.getBoolean("idea.use.dev.build.server")) {
                    while (root.getParent() != null && !Files.exists(root.resolve(ULTIMATE_MARKER), new LinkOption[0]) && !Files.exists(root.resolve(COMMUNITY_MARKER), new LinkOption[0])) {
                        root = root.getParent();
                    }
                }
                ourBinDirectories = PathManager.getBinDirectories(root);
            }
            ourHomePath = result;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result = ourBinDirectories;
        if (result == null) {
            PathManager.getHomePath(true);
            result = ourBinDirectories;
        }
        return result;
    }

    public static boolean isUnderHomeDirectory(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        try {
            return PathManager.isUnderHomeDirectory(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static boolean isUnderHomeDirectory(@NotNull Path target) {
        if (target == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        Path home = Paths.get(PathManager.getHomePath(), new String[0]);
        try {
            home = home.toRealPath(new LinkOption[0]);
            target = target.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return target.startsWith(home);
    }

    @ApiStatus.Internal
    @TestOnly
    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        Path result;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        return (result = PathManager.getHomeDirFor(aClass)) == null ? null : result.toString();
    }

    @ApiStatus.Internal
    @TestOnly
    @Nullable
    public static Path getHomeDirFor(@NotNull Class<?> aClass) {
        Path path;
        String home;
        String rootPath;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        String relevantJarsRoot = ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation();
        if (relevantJarsRoot != null && rootPath.startsWith(relevantJarsRoot) && (home = System.getProperty(PROPERTY_HOME_PATH)) != null && PathManager.isIdeaHome(path = Paths.get(home, new String[0]).toAbsolutePath())) {
            return path;
        }
        Path root = Paths.get(rootPath, new String[0]);
        Path ideaHomeUpwards = PathManager.getIdeaHomeUpwards(root);
        if (ideaHomeUpwards != null) {
            return ideaHomeUpwards;
        }
        try {
            Path ideaHomeFromBazelOut = PathManager.getIdeaHomeFromBazelExecRoot(root);
            if (ideaHomeFromBazelOut != null) {
                return ideaHomeFromBazelOut;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Nullable
    private static Path getIdeaHomeUpwards(Path start) {
        Path root = start.toAbsolutePath();
        while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
        }
        return root;
    }

    @Nullable
    private static Path getIdeaHomeFromBazelExecRoot(Path start) throws IOException {
        String workspacePrefix = "WORKSPACE: ";
        for (Path root = start.toAbsolutePath(); root != null && root.getParent() != null; root = root.getParent()) {
            Path workspaceLocation;
            String firstLine;
            Path readme = root.getParent().resolve("README");
            Path fileName = root.getFileName();
            if (fileName == null || !fileName.toString().equals("execroot") || !Files.isRegularFile(readme, new LinkOption[0]) || !(firstLine = Files.readAllLines(readme).get(0)).startsWith(workspacePrefix) || !PathManager.isIdeaHome(workspaceLocation = Paths.get(firstLine.substring(workspacePrefix.length()), new String[0]))) continue;
            return workspaceLocation;
        }
        return null;
    }

    private static boolean isIdeaHome(Path root) {
        return Files.isRegularFile(root.resolve(PRODUCT_INFO_JSON), new LinkOption[0]) || Files.isRegularFile(root.resolve("Resources").resolve(PRODUCT_INFO_JSON), new LinkOption[0]) || Files.isRegularFile(root.resolve(COMMUNITY_MARKER), new LinkOption[0]) || Files.isRegularFile(root.resolve(ULTIMATE_MARKER), new LinkOption[0]);
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        Path[] candidates = new Path[]{root.resolve(BIN_DIRECTORY), Paths.get(PathManager.getCommunityHomePath(root.toString()), BIN_DIRECTORY)};
        String osSuffix = OS.CURRENT == OS.Windows ? "win" : (OS.CURRENT == OS.macOS ? "mac" : "linux");
        for (Path dir : candidates) {
            String arch;
            if (binDirs.contains(dir) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            String string = CpuArch.isIntel64() ? "amd64" : (arch = CpuArch.isArm64() ? "aarch64" : null);
            if (arch == null || !Files.isDirectory(dir = dir.resolve(arch), new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static Path getBinDir() {
        Path path = PathManager.getHomeDir().resolve(BIN_DIRECTORY);
        if (path == null) {
            PathManager.$$$reportNull$$$0(6);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getBinPath() {
        String string = PathManager.getBinDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static Path findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(8);
        }
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static Path findBinFileWithException(@NotNull String fileName) {
        Path file;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(9);
        }
        if ((file = PathManager.findBinFile(fileName)) != null) {
            Path path = file;
            if (path == null) {
                PathManager.$$$reportNull$$$0(10);
            }
            return path;
        }
        StringBuilder message = new StringBuilder();
        message.append('\'').append(fileName).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message.append('\n').append(directory);
        }
        throw new RuntimeException(message.toString());
    }

    @NotNull
    public static Path getLibDir() {
        Path path = PathManager.getHomeDir().resolve(LIB_DIRECTORY);
        if (path == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getLibPath() {
        String string = PathManager.getLibDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static Path getBundledPluginsDir() {
        Path path = PathManager.getHomeDir().resolve(PLUGINS_DIRECTORY);
        if (path == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getPreInstalledPluginsPath() {
        String string = PathManager.getBundledPluginsDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static Path getBundledRuntimeDir() {
        Path path = PathManager.getHomeDir().resolve(JRE_DIRECTORY + (OS.CURRENT == OS.macOS ? "/Contents/Home" : ""));
        if (path == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getBundledRuntimePath() {
        String string = PathManager.getBundledRuntimeDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static synchronized Path getCommonDataPath() {
        Path path = ourCommonDataPath;
        if (path == null) {
            path = Paths.get(PathManager.platformPath("", "Application Support", "", "APPDATA", "", "XDG_DATA_HOME", ".local/share", ""), new String[0]);
            if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to create " + path + ", user.home=" + System.getProperty("user.home"), e);
                }
            }
            ourCommonDataPath = path;
        }
        Path path2 = path;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return path2;
    }

    @ApiStatus.Internal
    @Nullable
    public static String getPathsSelector() {
        return ourPathSelector;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static void setPathSelector(@NotNull String newValue) {
        if (newValue == null) {
            PathManager.$$$reportNull$$$0(18);
        }
        ourPathSelector = newValue;
        System.setProperty(PROPERTY_PATHS_SELECTOR, newValue);
    }

    @NotNull
    public static Path getConfigDir() {
        Path path = ourConfigPath;
        if (path == null) {
            Path explicit = PathManager.getExplicitPath(PROPERTY_CONFIG_PATH);
            path = explicit != null ? explicit : (ourPathSelector != null ? Paths.get(PathManager.getDefaultConfigPathFor(ourPathSelector), new String[0]) : PathManager.getHomeDir().resolve(CONFIG_DIRECTORY));
            ourConfigPath = path;
        }
        Path path2 = path;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        return path2;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getConfigPath() {
        String string = PathManager.getConfigDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(20);
        }
        return string;
    }

    @TestOnly
    @ApiStatus.Internal
    public static void setExplicitConfigPath(@NotNull Path path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(21);
        }
        ourConfigPath = path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getScratchPath() {
        String string = PathManager.getScratchDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static Path getScratchDir() {
        Path path = ourScratchPath;
        if (path == null) {
            Path explicit = PathManager.getExplicitPath(PROPERTY_SCRATCH_PATH);
            path = explicit == null ? PathManager.getConfigDir() : explicit;
            ourScratchPath = path;
        }
        Path path2 = path;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(23);
        }
        return path2;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        String string = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        return string;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getOptionsPath() {
        String string = PathManager.getOptionsDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static Path getOptionsDir() {
        Path path = PathManager.getConfigDir().resolve(OPTIONS_DIRECTORY);
        if (path == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        return path;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static File getOptionsFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        File file = PathManager.getOptionsDir().resolve(fileName + DEFAULT_EXT).toFile();
        if (file == null) {
            PathManager.$$$reportNull$$$0(29);
        }
        return file;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getPluginsPath() {
        String string = PathManager.getPluginsDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static Path getPluginsDir() {
        Path path = ourPluginPath;
        if (path == null) {
            Path explicit = PathManager.getExplicitPath(PROPERTY_PLUGINS_PATH);
            path = explicit != null ? explicit : (ourPathSelector != null && System.getProperty(PROPERTY_CONFIG_PATH) == null ? Paths.get(PathManager.getDefaultPluginPathFor(ourPathSelector), new String[0]) : PathManager.getConfigDir().resolve(PLUGINS_DIRECTORY));
            ourPluginPath = path;
        }
        Path path2 = path;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        return path2;
    }

    @ApiStatus.Internal
    @NotNull
    public static String getDefaultPluginPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        String string = PathManager.platformPath(selector, "Application Support", PLUGINS_DIRECTORY, "APPDATA", PLUGINS_DIRECTORY, "XDG_DATA_HOME", ".local/share", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    public static String getCustomOptionsDirectory() {
        return ourPathSelector != null ? PathManager.getDefaultConfigPathFor(ourPathSelector) : null;
    }

    @NotNull
    public static Path getSystemDir() {
        Path path = ourSystemPath;
        if (path == null) {
            Path explicit = PathManager.getExplicitPath(PROPERTY_SYSTEM_PATH);
            path = explicit != null ? explicit : (ourPathSelector != null ? Paths.get(PathManager.getDefaultSystemPathFor(ourPathSelector), new String[0]) : PathManager.getHomeDir().resolve(SYSTEM_DIRECTORY));
            ourSystemPath = path;
        }
        Path path2 = path;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        return path2;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getSystemPath() {
        String string = PathManager.getSystemDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        return PathManager.getDefaultSystemPathFor(OS.CURRENT, System.getProperty("user.home"), selector, System.getenv());
    }

    @ApiStatus.Internal
    @NotNull
    public static String getDefaultSystemPathFor(@NotNull OS os, @NotNull String userHome, @NotNull String selector) {
        if (os == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        if (userHome == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        if (selector == null) {
            PathManager.$$$reportNull$$$0(39);
        }
        return PathManager.getDefaultSystemPathFor(os, userHome, selector, System.getenv());
    }

    @ApiStatus.Internal
    @NotNull
    public static String getDefaultSystemPathFor(@NotNull OS os, @NotNull String userHome, @NotNull String selector, @NotNull Map<String, String> env) {
        if (os == null) {
            PathManager.$$$reportNull$$$0(40);
        }
        if (userHome == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        if (selector == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        if (env == null) {
            PathManager.$$$reportNull$$$0(43);
        }
        String string = PathManager.platformPath(os, env, userHome, selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    public static Path getTempDir() {
        Path path = PathManager.getSystemDir().resolve("tmp");
        if (path == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        return path;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getTempPath() {
        String string = PathManager.getTempDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getIndexRoot() {
        Path explicit = PathManager.getExplicitPath("index_root_path");
        Path path = explicit != null ? explicit : PathManager.getSystemDir().resolve("index");
        if (path == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        return path;
    }

    @NotNull
    public static Path getLogDir() {
        Path path = ourLogPath;
        if (path == null) {
            Path explicit = PathManager.getExplicitPath(PROPERTY_LOG_PATH);
            path = explicit != null ? explicit : (ourPathSelector != null && System.getProperty(PROPERTY_SYSTEM_PATH) == null ? Paths.get(PathManager.getDefaultLogPathFor(ourPathSelector), new String[0]) : PathManager.getSystemDir().resolve(LOG_DIRECTORY));
            ourLogPath = path;
        }
        Path path2 = path;
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(48);
        }
        return path2;
    }

    @ApiStatus.Obsolete
    @NotNull
    public static String getLogPath() {
        String string = PathManager.getLogDir().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(49);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static String getDefaultLogPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(50);
        }
        String string = PathManager.platformPath(selector, "Logs", "", "LOCALAPPDATA", LOG_DIRECTORY, "XDG_CACHE_HOME", ".cache", LOG_DIRECTORY);
        if (string == null) {
            PathManager.$$$reportNull$$$0(51);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getStartupScriptDir() {
        Path path = ourStartupScriptDir != null ? ourStartupScriptDir : PathManager.getSystemDir().resolve(PLUGINS_DIRECTORY);
        if (path == null) {
            PathManager.$$$reportNull$$$0(52);
        }
        return path;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static String getPluginTempPath() {
        String string = PathManager.getSystemDir().resolve(PLUGINS_DIRECTORY).toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(53);
        }
        return string;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        if ((url = context.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader classLoader, @NotNull String resourcePath) {
        URL url;
        if (classLoader == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(57);
        }
        return (url = classLoader.getResource(resourcePath)) == null ? null : PathManager.extractRoot(url, "/" + resourcePath);
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.isEmpty() || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        switch (resourceURL.getProtocol()) {
            case "file": {
                Path result;
                try {
                    result = Paths.get(resourceURL.toURI());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("URL='" + resourceURL + "'", e);
                }
                String path = result.toString();
                String testPath = path.replace('\\', '/');
                String testResourcePath = resourcePath.replace('\\', '/');
                if (!StringUtilRt.endsWithIgnoreCase((CharSequence)testPath, (CharSequence)testResourcePath)) break;
                resultPath = path.substring(0, path.length() - resourcePath.length());
                break;
            }
            case "jar": {
                String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
                if (jarPath == null) break;
                resultPath = jarPath;
                break;
            }
            case "jrt": {
                return null;
            }
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(String url) {
        int pivot = url.indexOf("!/");
        if (pivot < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            Path result;
            URL parsedUrl = new URL(jarPath);
            try {
                result = Paths.get(parsedUrl.toURI());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + parsedUrl + "'", e);
            }
            return result.toString().replace('\\', '/');
        }
        catch (Exception e) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    @ApiStatus.Internal
    public static void loadProperties() {
        String optionsDir;
        ArrayList<Path> files = new ArrayList<Path>();
        String customFile = System.getProperty(PROPERTIES_FILE);
        if (customFile != null) {
            files.add(Paths.get(customFile, new String[0]));
        }
        if ((optionsDir = PathManager.getCustomOptionsDirectory()) != null) {
            files.add(Paths.get(optionsDir, PROPERTIES_FILE_NAME));
        }
        files.add(Paths.get(System.getProperty("user.home"), PROPERTIES_FILE_NAME));
        for (Path binDir : PathManager.getBinDirectories()) {
            files.add(binDir.resolve(PROPERTIES_FILE_NAME));
        }
        final Properties sysProperties = System.getProperties();
        final String homePath = PathManager.getHomePath();
        for (final Path file : files) {
            try {
                BufferedReader reader = Files.newBufferedReader(file);
                try {
                    new Properties(){

                        @Override
                        public Object put(Object key, Object value) {
                            if (PathManager.PROPERTY_HOME_PATH.equals(key) || PathManager.PROPERTY_HOME.equals(key)) {
                                PathManager.log(file + ": '" + key + "' cannot be redefined");
                            } else if (!sysProperties.containsKey(key)) {
                                sysProperties.setProperty((String)key, PathManager.substituteVars((String)value, homePath));
                            }
                            return null;
                        }
                    }.load(reader);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (AccessDeniedException | NoSuchFileException reader) {
            }
            catch (IOException e) {
                PathManager.log("Can't read property file '" + file + "': " + e.getMessage());
            }
        }
        if (Boolean.parseBoolean(System.getProperty("jbScreenMenuBar.enabled", "true"))) {
            sysProperties.setProperty("apple.laf.useScreenMenuBar", "false");
        }
    }

    @ApiStatus.Internal
    public static void customizePaths(List<String> args) {
        String property = System.getProperty(SYSTEM_PATHS_CUSTOMIZER);
        if (property == null) {
            return;
        }
        try {
            PathCustomizer.CustomPaths paths;
            Class<?> aClass = PathManager.class.getClassLoader().loadClass(property);
            Object customizer = aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (customizer instanceof PathCustomizer && (paths = ((PathCustomizer)customizer).customizePaths(args)) != null) {
                ourOriginalConfigDir = PathManager.getConfigDir();
                ourOriginalSystemDir = PathManager.getSystemDir();
                ourOriginalLogDir = PathManager.getLogDir();
                if (paths.configPath != null) {
                    System.setProperty(PROPERTY_CONFIG_PATH, paths.configPath);
                }
                if (paths.systemPath != null) {
                    System.setProperty(PROPERTY_SYSTEM_PATH, paths.systemPath);
                }
                if (paths.pluginsPath != null) {
                    System.setProperty(PROPERTY_PLUGINS_PATH, paths.pluginsPath);
                }
                if (paths.logDirPath != null) {
                    System.setProperty(PROPERTY_LOG_PATH, paths.logDirPath);
                }
                if (paths.startupScriptDir != null) {
                    ourStartupScriptDir = paths.startupScriptDir;
                }
                ourConfigPath = null;
                ourSystemPath = null;
                ourPluginPath = null;
                ourScratchPath = null;
                ourLogPath = null;
            }
        }
        catch (Throwable e) {
            PathManager.log("Failed to set up '" + property + "' as PathCustomizer: " + e);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getOriginalConfigDir() {
        return ourOriginalConfigDir != null ? ourOriginalConfigDir : PathManager.getConfigDir();
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getOriginalSystemDir() {
        return ourOriginalSystemDir != null ? ourOriginalSystemDir : PathManager.getSystemDir();
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getOriginalLogDir() {
        return ourOriginalLogDir != null ? ourOriginalLogDir : PathManager.getLogDir();
    }

    @ApiStatus.Internal
    @Contract(value="null, _ -> null")
    public static String substituteVars(String s, @NotNull String ideaHomePath) {
        if (ideaHomePath == null) {
            PathManager.$$$reportNull$$$0(58);
        }
        if (s == null) {
            return null;
        }
        if (s.startsWith("..")) {
            s = ideaHomePath + '/' + BIN_DIRECTORY + '/' + s;
        }
        Matcher m = Lazy.PROPERTY_REF.matcher(s);
        while (m.find()) {
            String key = m.group(1);
            String value = System.getProperty(key);
            if (value == null) {
                switch (key) {
                    case "idea.home.path": 
                    case "idea.home": {
                        value = ideaHomePath;
                        break;
                    }
                    case "idea.config.path": {
                        value = PathManager.getConfigPath();
                        break;
                    }
                    case "idea.system.path": {
                        value = PathManager.getSystemPath();
                    }
                }
            }
            if (value == null) {
                PathManager.log("Unknown property: " + key);
                value = "";
            }
            s = s.replace(m.group(), value);
            m = Lazy.PROPERTY_REF.matcher(s);
        }
        return s;
    }

    @ApiStatus.Internal
    @NotNull
    public static String getCommunityHomePath() {
        String string = PathManager.getCommunityHomePath(PathManager.getHomePath());
        if (string == null) {
            PathManager.$$$reportNull$$$0(59);
        }
        return string;
    }

    private static String getCommunityHomePath(String homePath) {
        if (Boolean.getBoolean("idea.use.dev.build.server") || Files.isDirectory(Paths.get(homePath, ".idea"), new LinkOption[0])) {
            Path[] possibleCommunityPathList;
            for (Path possibleCommunityPath : possibleCommunityPathList = new Path[]{Paths.get(homePath, "community"), Paths.get(homePath, "..", "..", "..", "community"), Paths.get(homePath, "..", "..", "..", "..", "community")}) {
                if (!Files.isRegularFile(possibleCommunityPath.resolve(COMMUNITY_MARKER), new LinkOption[0])) continue;
                return possibleCommunityPath.normalize().toString();
            }
        }
        return homePath;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        Path resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(60);
        }
        return (resourceRoot = PathManager.getJarForClass(aClass)) == null ? null : resourceRoot.toString();
    }

    @Nullable
    public static Path getJarForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(61);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null ? null : Paths.get(resourceRoot, new String[0]).toAbsolutePath();
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(62);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        String string = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        if (string == null) {
            PathManager.$$$reportNull$$$0(63);
        }
        return string;
    }

    @Nullable
    private static Path getExplicitPath(String property) {
        String path = System.getProperty(property);
        if (path == null) {
            return null;
        }
        try {
            boolean quoted = path.length() > 1 && '\"' == path.charAt(0) && '\"' == path.charAt(path.length() - 1);
            return PathManager.toAbsoluteNormalizedPath(quoted ? path.substring(1, path.length() - 1) : path);
        }
        catch (InvalidPathException e) {
            Logger.getInstance(PathManager.class).error("Invalid value for property '" + property + "'", e);
            return null;
        }
    }

    private static Path toAbsoluteNormalizedPath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(64);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        return Paths.get(path, new String[0]).toAbsolutePath().normalize();
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        return PathManager.platformPath(OS.CURRENT, System.getenv(), System.getProperty("user.home"), selector, macDir, macSub, winVar, winSub, xdgVar, xdgDfl, xdgSub);
    }

    private static String platformPath(OS os, Map<String, String> env, String userHome, String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String dir;
        String vendorName = PathManager.vendorName();
        switch (os) {
            case Windows: {
                String dir2 = env.get(winVar);
                if (dir2 == null || dir2.isEmpty()) {
                    dir2 = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
                }
                dir2 = dir2 + '\\' + vendorName;
                if (!selector.isEmpty()) {
                    dir2 = dir2 + '\\' + selector;
                }
                if (!winSub.isEmpty()) {
                    dir2 = dir2 + '\\' + winSub;
                }
                return dir2;
            }
            case macOS: {
                String dir3 = userHome + "/Library/" + macDir + '/' + vendorName;
                if (!selector.isEmpty()) {
                    dir3 = dir3 + '/' + selector;
                }
                if (!macSub.isEmpty()) {
                    dir3 = dir3 + '/' + macSub;
                }
                return dir3;
            }
        }
        String string = dir = xdgVar != null ? env.get(xdgVar) : null;
        if (dir == null || dir.isEmpty()) {
            dir = userHome + '/' + xdgDfl;
        }
        dir = dir + '/' + PathManager.vendorName();
        if (!selector.isEmpty()) {
            dir = dir + '/' + selector;
        }
        if (!xdgSub.isEmpty()) {
            dir = dir + '/' + xdgSub;
        }
        return dir;
    }

    private static String vendorName() {
        String property = System.getProperty(PROPERTY_VENDOR_NAME);
        if (property == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (property == null) {
                property = "JetBrains";
            }
            System.setProperty(PROPERTY_VENDOR_NAME, property);
        }
        return property;
    }

    static {
        ourPathSelector = System.getProperty(PROPERTY_PATHS_SELECTOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 2: 
            case 21: 
            case 55: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: 
            case 5: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 9: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 24: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHome";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDir";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibDir";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledPluginsDir";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledRuntimeDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledRuntimePath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonDataPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchDir";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsDir";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsDir";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDir";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDir";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDir";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLogPathFor";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupScriptDir";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHomeDirFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setPathSelector";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setExplicitConfigPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLogPathFor";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getJarForClass";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "toAbsoluteNormalizedPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 50: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Lazy {
        private static final Pattern PROPERTY_REF = Pattern.compile("\\$\\{(.+?)}");

        private Lazy() {
        }
    }
}

