/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.PatternGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestMethodGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class TestClassGradleConfigurationProducer
extends AbstractGradleTestRunConfigurationProducer<PsiClass, PsiClass> {
    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (other == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(1);
        }
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && !other.isProducedBy(TestMethodGradleConfigurationProducer.class) && super.isPreferredConfiguration(self, other);
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (other == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(3);
        }
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && !other.isProducedBy(TestMethodGradleConfigurationProducer.class) && super.shouldReplace(self, other);
    }

    @Nullable
    protected PsiClass getPsiClassForLocation(Location<?> contextLocation) {
        PsiClass[] classes;
        Location location = JavaExecutionUtil.stepIntoSingleClass(contextLocation);
        if (location == null) {
            return null;
        }
        TestFrameworks testFrameworks = TestFrameworks.getInstance();
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!testFrameworks.isTestClass((PsiClass)classLocation.getPsiElement())) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiClassOwner && (classes = ((PsiClassOwner)element).getClasses()).length == 1 && testFrameworks.isTestClass(classes[0])) {
            return classes[0];
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiClass getElement(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((location = context.getLocation()) == null) {
            return null;
        }
        PsiClass psiClass = this.getPsiClassForLocation(location);
        if (psiClass == null) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile source = psiFile.getVirtualFile();
        if (source == null) {
            return null;
        }
        return psiClass;
    }

    @Override
    @NotNull
    protected String getLocationName(@NotNull ConfigurationContext context, @NotNull PsiClass element) {
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (element == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(6);
        }
        String string = Objects.requireNonNull(element.getName());
        if (string == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiClass element, @NotNull List<? extends PsiClass> chosenElements) {
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (element == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (chosenElements == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(10);
        }
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(element) : chosenElements;
        String string = StringUtil.join(elements, aClass -> aClass.getName(), (String)"|");
        if (string == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    protected void chooseSourceElements(@NotNull ConfigurationContext context, @NotNull PsiClass element, @NotNull Consumer<List<PsiClass>> onElementsChosen) {
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (element == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (onElementsChosen == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(14);
        }
        InheritorChooser.chooseAbstractClassInheritors((ConfigurationContext)context, (PsiClass)element, onElementsChosen);
    }

    @Override
    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiClass element, @NotNull List<? extends PsiClass> chosenElements) {
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (element == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (chosenElements == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(17);
        }
        Project project = Objects.requireNonNull(context.getProject());
        VirtualFile source = Objects.requireNonNull(element.getContainingFile().getVirtualFile());
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(element) : chosenElements;
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> testsTasksToRun = new ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun>();
        for (PsiClass psiClass : elements) {
            String testFilter = GradleExecutionSettingsUtil.createTestFilterFrom(psiClass);
            testsTasksToRun.addAll(ContainerUtil.map(TestClassGradleConfigurationProducer.findAllTestsTaskToRun(source, project), it -> new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)it, testFilter)));
        }
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> arrayList = testsTasksToRun;
        if (arrayList == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static boolean pointsToMethod(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(19);
        }
        return (location = context.getLocation()) != null && GradleRunnerUtil.getMethodLocation(location) != null;
    }

    @Override
    protected boolean doSetupConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(20);
        }
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(21);
        }
        if (sourceElement == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(22);
        }
        if (TestClassGradleConfigurationProducer.pointsToMethod(context)) {
            return false;
        }
        return super.doSetupConfigurationFromContext(configuration, context, sourceElement);
    }

    @Override
    protected boolean doIsConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(23);
        }
        if (context == null) {
            TestClassGradleConfigurationProducer.$$$reportNull$$$0(24);
        }
        if (TestClassGradleConfigurationProducer.pointsToMethod(context)) {
            return false;
        }
        return super.doIsConfigurationFromContext(configuration, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/TestClassGradleConfigurationProducer";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onElementsChosen";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/TestClassGradleConfigurationProducer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestConfigurationName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTestsTaskToRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocationName";
                break;
            }
            case 7: 
            case 11: 
            case 18: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "chooseSourceElements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllTestsTaskToRun";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "pointsToMethod";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doSetupConfigurationFromContext";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doIsConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 18 -> new IllegalStateException(string);
        };
    }
}

