/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentUnindentHandlerBase;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListItemTabHandler$doIndentUnindent$;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListItemTabHandler;", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentUnindentHandlerBase;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "doIndentUnindent", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "document", "Lcom/intellij/openapi/editor/Document;", "updateNumbering", "", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownListItemTabHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownListItemTabHandler.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListItemTabHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,50:1\n477#2:51\n66#3,2:52\n*S KotlinDebug\n*F\n+ 1 MarkdownListItemTabHandler.kt\norg/intellij/plugins/markdown/editor/lists/MarkdownListItemTabHandler\n*L\n28#1:51\n47#1:52,2\n*E\n"})
public final class MarkdownListItemTabHandler
extends ListItemIndentUnindentHandlerBase {
    public MarkdownListItemTabHandler(@Nullable EditorActionHandler baseHandler) {
        super(baseHandler);
    }

    @Override
    protected boolean doIndentUnindent(@NotNull MarkdownListItem item, @NotNull MarkdownFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ListItemInfo itemInfo = new ListItemInfo(item, document);
        PsiElement psiElement = item.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
        MarkdownList list2 = (MarkdownList)psiElement;
        Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)list2), (boolean)false, (boolean)false);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)doIndentUnindent$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        MarkdownList prevList = (MarkdownList)SequencesKt.firstOrNull((Sequence)sequence);
        Object object = prevList;
        if (object == null || (object = ListUtils.INSTANCE.getItems((MarkdownList)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        List siblings = CollectionsKt.plus((Collection)((Collection)object), (Iterable)ListUtils.INSTANCE.getItems(list2));
        MarkdownListItem markdownListItem = (MarkdownListItem)CollectionsKt.getOrNull((List)siblings, (int)(siblings.indexOf(item) - 1));
        if (markdownListItem == null) {
            return false;
        }
        MarkdownListItem prevItem = markdownListItem;
        ListItemInfo prevInfo = new ListItemInfo(prevItem, document);
        if (itemInfo.getLines().getFirst() - prevInfo.getLines().getLast() > 2) {
            return false;
        }
        Replacement.Companion.replaceSafelyIn$intellij_markdown(itemInfo.changeIndent(prevInfo.getIndentInfo().subItemIndent()), document);
        return true;
    }

    @Override
    protected void updateNumbering(@NotNull MarkdownListItem item, @NotNull MarkdownFile file, @NotNull Document document) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            PsiElement psiElement = item.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
            MarkdownList list2 = (MarkdownList)psiElement;
            ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, list2, document, false, Intrinsics.areEqual((Object)CollectionsKt.first(ListUtils.INSTANCE.getItems(list2)), (Object)item), false, false, 24, null);
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)list2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            MarkdownList markdownList = (MarkdownList)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownList.class, (boolean)true);
            if (markdownList == null) break block0;
            ListRenumberUtils.renumberInBulk$default(ListRenumberUtils.INSTANCE, markdownList, document, false, false, false, false, 24, null);
        }
    }
}

