/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ProcessOutput {
    private final StringBuilder myStdoutBuilder;
    private final StringBuilder myStderrBuilder;
    @Nullable
    private volatile Integer myExitCode;
    private volatile boolean myTimeout;
    private volatile boolean myCancelled;

    public ProcessOutput() {
        this("", "", null, false, false);
    }

    public ProcessOutput(int exitCode) {
        this("", "", exitCode, false, false);
    }

    public ProcessOutput(@NotNull String stdout, @NotNull String stderr, int exitCode, boolean timeout, boolean cancelled) {
        if (stdout == null) {
            ProcessOutput.$$$reportNull$$$0(0);
        }
        if (stderr == null) {
            ProcessOutput.$$$reportNull$$$0(1);
        }
        this(stdout, stderr, (Integer)exitCode, timeout, cancelled);
    }

    private ProcessOutput(@NotNull String stdout, @NotNull String stderr, @Nullable Integer exitCode, boolean timeout, boolean cancelled) {
        if (stdout == null) {
            ProcessOutput.$$$reportNull$$$0(2);
        }
        if (stderr == null) {
            ProcessOutput.$$$reportNull$$$0(3);
        }
        this.myStdoutBuilder = new StringBuilder(stdout);
        this.myStderrBuilder = new StringBuilder(stderr);
        this.myExitCode = exitCode;
        this.myTimeout = timeout;
        this.myCancelled = cancelled;
    }

    public void appendStdout(@Nullable String text) {
        ProcessOutput.appendWithBackspaceHandling(this.myStdoutBuilder, text);
    }

    public void appendStderr(@Nullable String text) {
        ProcessOutput.appendWithBackspaceHandling(this.myStderrBuilder, text);
    }

    @NotNull
    @NlsSafe
    public String getStdout() {
        String string = this.myStdoutBuilder.toString();
        if (string == null) {
            ProcessOutput.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getStderr() {
        String string = this.myStderrBuilder.toString();
        if (string == null) {
            ProcessOutput.$$$reportNull$$$0(5);
        }
        return string;
    }

    public @Unmodifiable @NotNull List<@NlsSafe String> getStdoutLines() {
        List<String> list = this.getStdoutLines(true);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(6);
        }
        return list;
    }

    public @Unmodifiable @NotNull List<@NlsSafe String> getStdoutLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStdout(), excludeEmptyLines);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(7);
        }
        return list;
    }

    public @Unmodifiable @NotNull List<@NlsSafe String> getStderrLines() {
        List<String> list = this.getStderrLines(true);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(8);
        }
        return list;
    }

    public @Unmodifiable @NotNull List<@NlsSafe String> getStderrLines(boolean excludeEmptyLines) {
        List<String> list = ProcessOutput.splitLines(this.getStderr(), excludeEmptyLines);
        if (list == null) {
            ProcessOutput.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static @Unmodifiable List<String> splitLines(String s, boolean excludeEmptyLines) {
        String converted = StringUtil.convertLineSeparators((String)s);
        return StringUtil.split((String)converted, (String)"\n", (boolean)true, (boolean)excludeEmptyLines);
    }

    public boolean checkSuccess(@NotNull Logger logger) {
        int ec;
        if (logger == null) {
            ProcessOutput.$$$reportNull$$$0(10);
        }
        if ((ec = this.getExitCode()) == 0 && !this.isTimeout()) {
            return true;
        }
        logger.info((String)(this.isTimeout() ? "Timed out" : "Exit code " + ec));
        String output = this.getStderr();
        if (output.isEmpty()) {
            output = this.getStdout();
        }
        if (!output.isEmpty()) {
            logger.info(output);
        }
        return false;
    }

    public void setExitCode(int exitCode) {
        this.myExitCode = exitCode;
    }

    public int getExitCode() {
        Integer code = this.myExitCode;
        return code == null ? -1 : code;
    }

    public boolean isExitCodeSet() {
        return this.myExitCode != null;
    }

    public void setTimeout() {
        this.myTimeout = true;
    }

    public boolean isTimeout() {
        return this.myTimeout;
    }

    public void setCancelled() {
        this.myCancelled = true;
    }

    public boolean isCancelled() {
        return this.myCancelled;
    }

    public String toString() {
        return "{exitCode=" + this.myExitCode + ", timeout=" + this.myTimeout + ", cancelled=" + this.myCancelled + ", stdout=" + String.valueOf(this.myStdoutBuilder) + ", stderr=" + String.valueOf(this.myStderrBuilder) + "}";
    }

    private static void appendWithBackspaceHandling(@NotNull StringBuilder builder, @Nullable String text) {
        if (builder == null) {
            ProcessOutput.$$$reportNull$$$0(11);
        }
        if (text == null) {
            return;
        }
        if (text.contains("\b")) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\b') {
                    int length = builder.length();
                    if (length <= 0) continue;
                    builder.deleteCharAt(length - 1);
                    continue;
                }
                builder.append(c);
            }
        } else {
            builder.append(text);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessOutput";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessOutput";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdout";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderr";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdoutLines";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStderrLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkSuccess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendWithBackspaceHandling";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

