/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.core.internal.AbstractComparisonStrategy;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Streams;

public class StandardComparisonStrategy
extends AbstractComparisonStrategy {
    private static final StandardComparisonStrategy INSTANCE = new StandardComparisonStrategy();

    public static StandardComparisonStrategy instance() {
        return INSTANCE;
    }

    protected StandardComparisonStrategy() {
    }

    @Override
    protected Set<Object> newSetUsingComparisonStrategy() {
        return new TreeSet<Object>((o1, o2) -> {
            if (this.areEqual(o1, o2)) {
                return 0;
            }
            return Objects.hashCodeFor(o1) < Objects.hashCodeFor(o2) ? -1 : 1;
        });
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        Class<?> otherClass;
        if (actual == null) {
            return other == null;
        }
        Class<?> actualClass = actual.getClass();
        if (actualClass.isArray() && other != null && (otherClass = other.getClass()).isArray()) {
            Object[] a;
            if (actualClass.getComponentType().isPrimitive() && otherClass.getComponentType().isPrimitive()) {
                if (actual instanceof byte[]) {
                    a = (byte[])actual;
                    if (other instanceof byte[]) {
                        byte[] o = (byte[])other;
                        return Arrays.equals((byte[])a, o);
                    }
                }
                if (actual instanceof short[]) {
                    a = (short[])actual;
                    if (other instanceof short[]) {
                        short[] o = (short[])other;
                        return Arrays.equals((short[])a, o);
                    }
                }
                if (actual instanceof int[]) {
                    a = (int[])actual;
                    if (other instanceof int[]) {
                        int[] o = (int[])other;
                        return Arrays.equals((int[])a, o);
                    }
                }
                if (actual instanceof long[]) {
                    a = (long[])actual;
                    if (other instanceof long[]) {
                        long[] o = (long[])other;
                        return Arrays.equals((long[])a, o);
                    }
                }
                if (actual instanceof char[]) {
                    a = (char[])actual;
                    if (other instanceof char[]) {
                        char[] o = (char[])other;
                        return Arrays.equals((char[])a, o);
                    }
                }
                if (actual instanceof float[]) {
                    a = (float[])actual;
                    if (other instanceof float[]) {
                        float[] o = (float[])other;
                        return Arrays.equals((float[])a, o);
                    }
                }
                if (actual instanceof double[]) {
                    a = (double[])actual;
                    if (other instanceof double[]) {
                        double[] o = (double[])other;
                        return Arrays.equals((double[])a, o);
                    }
                }
                if (actual instanceof boolean[]) {
                    a = (boolean[])actual;
                    if (other instanceof boolean[]) {
                        boolean[] o = (boolean[])other;
                        return Arrays.equals((boolean[])a, o);
                    }
                }
            }
            if (actual instanceof Object[]) {
                a = (Object[])actual;
                if (other instanceof Object[]) {
                    Object[] o = (Object[])other;
                    return Arrays.deepEquals(a, o);
                }
            }
        }
        return actual.equals(other);
    }

    @Override
    public boolean iterableContains(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return false;
        }
        return Streams.stream(iterable).anyMatch(object -> this.areEqual(object, value));
    }

    @Override
    public void iterableRemoves(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            collection.removeIf(o -> this.areEqual(o, value));
        } else {
            Iterator<?> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                if (!this.areEqual(iterator.next(), value)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void iterablesRemoveFirst(Iterable<?> iterable, Object value) {
        if (iterable == null) {
            return;
        }
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            if (!this.areEqual(iterator.next(), value)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public Iterable<?> duplicatesFrom(Iterable<?> iterable) {
        return super.duplicatesFrom(iterable);
    }

    @Override
    public boolean stringStartsWith(String string, String prefix) {
        return string.startsWith(prefix);
    }

    @Override
    public boolean stringEndsWith(String string, String suffix) {
        return string.endsWith(suffix);
    }

    @Override
    public boolean stringContains(String string, String sequence) {
        return string.contains(sequence);
    }

    @Override
    public boolean isGreaterThan(Object actual, Object other) {
        if (actual instanceof Comparable) {
            Comparable comparable = (Comparable)actual;
            return comparable.compareTo(other) > 0;
        }
        throw new IllegalArgumentException("argument '%s' should be Comparable but is not".formatted(actual));
    }

    @Override
    public boolean isLessThan(Object actual, Object other) {
        if (actual instanceof Comparable) {
            Comparable comparable = (Comparable)actual;
            return comparable.compareTo(other) < 0;
        }
        throw new IllegalArgumentException("argument '%s' should be Comparable but is not".formatted(actual));
    }

    @Override
    public boolean isStandard() {
        return true;
    }
}

