/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtStubBasedElementTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinCollectionLiteralExpressionStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;

public class KtCollectionLiteralExpression
extends KtElementImplStub<KotlinCollectionLiteralExpressionStub>
implements KtReferenceExpression {
    public KtCollectionLiteralExpression(@NotNull KotlinCollectionLiteralExpressionStub stub) {
        if (stub == null) {
            KtCollectionLiteralExpression.$$$reportNull$$$0(0);
        }
        super(stub, KtStubBasedElementTypes.COLLECTION_LITERAL_EXPRESSION);
    }

    public KtCollectionLiteralExpression(@NotNull ASTNode node) {
        if (node == null) {
            KtCollectionLiteralExpression.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtCollectionLiteralExpression.$$$reportNull$$$0(2);
        }
        return visitor2.visitCollectionLiteralExpression(this, data);
    }

    @Nullable
    public PsiElement getLeftBracket() {
        ASTNode astNode = this.getNode().findChildByType((IElementType)KtTokens.LBRACKET);
        return astNode != null ? astNode.getPsi() : null;
    }

    @Nullable
    public PsiElement getRightBracket() {
        ASTNode astNode = this.getNode().findChildByType((IElementType)KtTokens.RBRACKET);
        return astNode != null ? astNode.getPsi() : null;
    }

    @Nullable
    public PsiElement getTrailingComma() {
        PsiElement rightBracket = this.getRightBracket();
        return KtPsiUtilKt.getTrailingCommaByClosingElement(rightBracket);
    }

    @NotNull
    public List<KtExpression> getInnerExpressions() {
        KotlinCollectionLiteralExpressionStub stub = (KotlinCollectionLiteralExpressionStub)this.getStub();
        if (stub != null) {
            int expressionsCount = stub.getInnerExpressionCount();
            if (expressionsCount == 0) {
                List<KtExpression> list = Collections.emptyList();
                if (list == null) {
                    KtCollectionLiteralExpression.$$$reportNull$$$0(3);
                }
                return list;
            }
            KtExpression[] constantExpressions = (KtExpression[])stub.getChildrenByType(KtTokenSets.CONSTANT_EXPRESSIONS, (PsiElement[])KtExpression.EMPTY_ARRAY);
            if (constantExpressions.length == expressionsCount) {
                List<KtExpression> list = Arrays.asList(constantExpressions);
                if (list == null) {
                    KtCollectionLiteralExpression.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, KtExpression.class);
        if (list == null) {
            KtCollectionLiteralExpression.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtCollectionLiteralExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtCollectionLiteralExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

