/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.ObjectNormalizer;
import com.intellij.util.containers.ClassMap;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseObjectNormalizer
implements ObjectNormalizer {
    private final MyMap<Object> myToObject = new MyMap();
    protected Converter<Object, Object> identity = new Converter<Object, Object>(this){

        @Override
        public Object convert(Object o, GridColumn column) {
            return o;
        }
    };

    public BaseObjectNormalizer() {
        this.put(Object[].class, this.identity);
        this.put(Boolean.class, this.identity);
        this.put(Number.class, this.identity);
        this.put(Timestamp.class, this.identity);
        this.put(Time.class, this.identity);
        this.put(String.class, this.identity);
        this.addToBoxedArrayConverters();
    }

    @Override
    @Nullable
    public Object objectToObject(@Nullable Object o, GridColumn column) {
        if (o == null) {
            return null;
        }
        Object result = this.object2ObjectImpl(o, column);
        return result != null ? result : this.object2ObjectImpl(String.valueOf(o), column);
    }

    @Nullable
    private Object object2ObjectImpl(@NotNull Object o, GridColumn column) {
        Converter converter;
        if (o == null) {
            BaseObjectNormalizer.$$$reportNull$$$0(0);
        }
        return (converter = (Converter)this.myToObject.get(this.getClass(o))) != null ? converter.convert(o, column) : null;
    }

    @NotNull
    protected Class<?> getClass(@NotNull Object o) {
        if (o == null) {
            BaseObjectNormalizer.$$$reportNull$$$0(1);
        }
        Class<?> clazz = o.getClass();
        if (clazz == null) {
            BaseObjectNormalizer.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    protected <X> void put(@NotNull Class<X> aClass, Converter<Object, Object> value) {
        if (aClass == null) {
            BaseObjectNormalizer.$$$reportNull$$$0(3);
        }
        this.myToObject.put(aClass, value);
    }

    protected <X> void register(@NotNull Class<X> aClass, Converter<X, Object> value) {
        if (aClass == null) {
            BaseObjectNormalizer.$$$reportNull$$$0(4);
        }
        this.myToObject.register(aClass, value);
    }

    private void addToBoxedArrayConverters() {
        this.register(boolean[].class, new Converter<boolean[], Object>(this){

            @Override
            public Object convert(boolean[] o, GridColumn column) {
                Object[] boxed = new Object[o.length];
                for (int i = 0; i < o.length; ++i) {
                    boxed[i] = o[i];
                }
                return boxed;
            }
        });
        this.register(byte[].class, new Converter<byte[], Object>(this){

            @Override
            public Object convert(byte[] o, GridColumn column) {
                Object[] boxed = new Object[o.length];
                for (int i = 0; i < o.length; ++i) {
                    boxed[i] = o[i];
                }
                return boxed;
            }
        });
        this.register(char[].class, new Converter<char[], Object>(this){

            @Override
            public Object convert(char[] o, GridColumn column) {
                Object[] boxed = new Object[o.length];
                for (int i = 0; i < o.length; ++i) {
                    boxed[i] = Character.valueOf(o[i]);
                }
                return boxed;
            }
        });
        this.register(double[].class, new Converter<double[], Object>(this){

            @Override
            public Object convert(double[] o, GridColumn column) {
                return Arrays.stream(o).boxed().toArray();
            }
        });
        this.register(float[].class, new Converter<float[], Object>(this){

            @Override
            public Object convert(float[] o, GridColumn column) {
                Object[] boxed = new Object[o.length];
                for (int i = 0; i < o.length; ++i) {
                    boxed[i] = Float.valueOf(o[i]);
                }
                return boxed;
            }
        });
        this.register(int[].class, new Converter<int[], Object>(this){

            @Override
            public Object convert(int[] o, GridColumn column) {
                return Arrays.stream(o).boxed().toArray();
            }
        });
        this.register(long[].class, new Converter<long[], Object>(this){

            @Override
            public Object convert(long[] o, GridColumn column) {
                return Arrays.stream(o).boxed().toArray();
            }
        });
        this.register(short[].class, new Converter<short[], Object>(this){

            @Override
            public Object convert(short[] o, GridColumn column) {
                Object[] boxed = new Object[o.length];
                for (int i = 0; i < o.length; ++i) {
                    boxed[i] = o[i];
                }
                return boxed;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/BaseObjectNormalizer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/BaseObjectNormalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "object2ObjectImpl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClass";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class MyMap<T>
    extends ClassMap<Converter<Object, T>> {
        private MyMap() {
            super(new ConcurrentHashMap());
        }

        public <X> void register(@NotNull Class<X> aClass, Converter<X, T> value) {
            if (aClass == null) {
                MyMap.$$$reportNull$$$0(0);
            }
            super.put(aClass, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/datagrid/BaseObjectNormalizer$MyMap", "register"));
        }
    }

    protected static interface Converter<X, V> {
        public V convert(X var1, GridColumn var2);
    }
}

