/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.core.nio.fs.DelegatingFileSystemProvider;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.impl.fs.MountsAwareFileSystem;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelMountProvider;
import com.intellij.platform.eel.provider.EelMountProviderKt;
import com.intellij.platform.eel.provider.EelMountRoot;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\b\b&\u0018\u0000 r2\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u0001rB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\t\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0014J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0014J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0014J\u001e\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u000fH&J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J%\u0010\u001c\u001a\u00020\u001d\"\f\b\u0000\u0010\u001e*\u0006\u0012\u0002\b\u00030\u001f*\b\u0012\u0004\u0012\u0002H\u001e0 H\u0002\u00a2\u0006\u0002\u0010!J[\u0010\"\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f2\u001a\u0010%\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0 \"\u0006\u0012\u0002\b\u00030\u001f2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u001e0'H\u0004\u00a2\u0006\u0002\u0010(J\u001e\u0010)\u001a\u00020\u001b*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0 H\u0082\u0002\u00a2\u0006\u0002\u0010*JF\u0010\"\u001a\u0004\u0018\u0001H\u001e\"\u0004\b\u0000\u0010\u001e*\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001b2!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b,\u0012\b\b-\u0012\u0004\b\b(.\u0012\u0004\u0012\u0002H\u001e0+H\u0004\u00a2\u0006\u0002\u0010/J+\u00100\u001a\u0002012\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u0002030 \"\u000203H\u0016\u00a2\u0006\u0002\u00104J+\u00105\u001a\u0002062\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u0002030 \"\u000203H\u0016\u00a2\u0006\u0002\u00107JA\u00108\u001a\u0002092\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030:2\u001a\u0010%\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0 \"\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a2\u0006\u0002\u0010;JA\u0010<\u001a\u00020=2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\f\u00102\u001a\b\u0012\u0004\u0012\u0002030:2\u001a\u0010%\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0 \"\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a2\u0006\u0002\u0010>JQ\u0010?\u001a\u0004\u0018\u00010@2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0010\u00102\u001a\f\u0012\u0006\u0012\u0004\u0018\u000103\u0018\u00010:2\b\u0010A\u001a\u0004\u0018\u00010B2\u001a\u0010%\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0 \"\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a2\u0006\u0002\u0010CJ\u0012\u0010D\u001a\u00020E2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J3\u0010F\u001a\u00020E2\b\u0010G\u001a\u0004\u0018\u00010\u000f2\u001a\u0010%\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0 \"\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a2\u0006\u0002\u0010HJ\u0012\u0010I\u001a\u00020\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010J\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J5\u0010K\u001a\u00020E2\b\u0010#\u001a\u0004\u0018\u00010\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000f2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020L0 \"\u00020LH\u0016\u00a2\u0006\u0002\u0010MJ5\u0010N\u001a\u00020E2\b\u0010#\u001a\u0004\u0018\u00010\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000f2\u0012\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020L0 \"\u00020LH\u0016\u00a2\u0006\u0002\u0010MJ\u001c\u0010O\u001a\u00020E2\b\u0010P\u001a\u0004\u0018\u00010\u000f2\b\u0010Q\u001a\u0004\u0018\u00010\u000fH\u0016J=\u0010R\u001a\u00020E2\b\u0010P\u001a\u0004\u0018\u00010\u000f2\b\u0010$\u001a\u0004\u0018\u00010\u000f2\u001a\u0010%\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001f0 \"\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a2\u0006\u0002\u0010SJ.\u0010T\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010U2\b\u0010G\u001a\u0004\u0018\u00010\u000f2\u0010\u0010V\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000f\u0018\u00010WH\u0016J+\u0010X\u001a\u00020E2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0012\u0010Y\u001a\n\u0012\u0006\b\u0001\u0012\u00020Z0 \"\u00020ZH\u0016\u00a2\u0006\u0002\u0010[JK\u0010\\\u001a\u0004\u0018\u0001H]\"\n\b\u0000\u0010]*\u0004\u0018\u00010^2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002H]0`2\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010a0 \"\u0004\u0018\u00010aH\u0016\u00a2\u0006\u0002\u0010bJ\u0012\u0010c\u001a\u00020\u001d2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010d\u001a\u00020\u000f2\u0006\u0010P\u001a\u00020\u000fH\u0016JO\u0010e\u001a\u0004\u0018\u0001Hf\"\n\b\u0000\u0010f*\u0004\u0018\u00010g2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0010\u0010_\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001Hf\u0018\u00010`2\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010a0 \"\u0004\u0018\u00010aH\u0016\u00a2\u0006\u0002\u0010hJK\u0010\\\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010j\u0012\u0006\u0012\u0004\u0018\u00010k\u0018\u00010i2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010l\u001a\u0004\u0018\u00010j2\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010a0 \"\u0004\u0018\u00010aH\u0016\u00a2\u0006\u0002\u0010mJC\u0010n\u001a\u00020E2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010o\u001a\u0004\u0018\u00010j2\b\u0010p\u001a\u0004\u0018\u00010k2\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010a0 \"\u0004\u0018\u00010aH\u0016\u00a2\u0006\u0002\u0010qR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006s"}, d2={"Lcom/intellij/platform/eel/impl/fs/MountsAwareFileSystemProvider;", "Lcom/intellij/platform/core/nio/fs/DelegatingFileSystemProvider;", "Lcom/intellij/platform/eel/impl/fs/MountsAwareFileSystem;", "delegate", "Ljava/nio/file/spi/FileSystemProvider;", "mountProvider", "Lcom/intellij/platform/eel/provider/EelMountProvider;", "<init>", "(Ljava/nio/file/spi/FileSystemProvider;Lcom/intellij/platform/eel/provider/EelMountProvider;)V", "getDelegate", "()Ljava/nio/file/spi/FileSystemProvider;", "wrapDelegateFileSystem", "delegateFs", "Ljava/nio/file/FileSystem;", "path1", "Ljava/nio/file/Path;", "path2", "wrapDelegatePath", "delegatePath", "toDelegatePath", "path", "unwrapEelPath", "Lkotlin/Pair;", "Lcom/intellij/platform/eel/path/EelPath;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi;", "getDirectAccessPath", "directAccess", "Lcom/intellij/platform/eel/provider/EelMountRoot$DirectAccessOptions;", "containsPosixAttribute", "", "T", "Ljava/nio/file/attribute/FileAttribute;", "", "([Ljava/nio/file/attribute/FileAttribute;)Z", "tryUseDirectAccess", "source", "target", "attrs", "block", "Lkotlin/Function2;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "unaryMinus", "([Ljava/nio/file/attribute/FileAttribute;)Lcom/intellij/platform/eel/provider/EelMountRoot$DirectAccessOptions;", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "directPath", "(Ljava/nio/file/Path;Lcom/intellij/platform/eel/provider/EelMountRoot$DirectAccessOptions;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "newInputStream", "Ljava/io/InputStream;", "options", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "newOutputStream", "Ljava/io/OutputStream;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "newByteChannel", "Ljava/nio/channels/SeekableByteChannel;", "", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/SeekableByteChannel;", "newFileChannel", "Ljava/nio/channels/FileChannel;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/FileChannel;", "newAsynchronousFileChannel", "Ljava/nio/channels/AsynchronousFileChannel;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Ljava/nio/file/Path;Ljava/util/Set;Ljava/util/concurrent/ExecutorService;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/AsynchronousFileChannel;", "delete", "", "createDirectory", "dir", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "deleteIfExists", "isSameFile", "copy", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "move", "createLink", "link", "existing", "createSymbolicLink", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "newDirectoryStream", "Ljava/nio/file/DirectoryStream;", "filter", "Ljava/nio/file/DirectoryStream$Filter;", "checkAccess", "modes", "Ljava/nio/file/AccessMode;", "(Ljava/nio/file/Path;[Ljava/nio/file/AccessMode;)V", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "type", "Ljava/lang/Class;", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "isHidden", "readSymbolicLink", "getFileAttributeView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "", "", "", "attributes", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "setAttribute", "attribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)V", "Companion", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nMountsAwareFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MountsAwareFileSystemProvider.kt\ncom/intellij/platform/eel/impl/fs/MountsAwareFileSystemProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,274:1\n12970#2,2:275\n12767#2,2:278\n1#3:277\n13#4:280\n*S KotlinDebug\n*F\n+ 1 MountsAwareFileSystemProvider.kt\ncom/intellij/platform/eel/impl/fs/MountsAwareFileSystemProvider\n*L\n57#1:275,2\n223#1:278,2\n257#1:280\n*E\n"})
public abstract class MountsAwareFileSystemProvider
extends DelegatingFileSystemProvider<MountsAwareFileSystemProvider, MountsAwareFileSystem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystemProvider delegate;
    @NotNull
    private final EelMountProvider mountProvider;
    @NotNull
    private static final Logger LOG;

    public MountsAwareFileSystemProvider(@NotNull FileSystemProvider delegate, @NotNull EelMountProvider mountProvider) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)mountProvider, (String)"mountProvider");
        this.delegate = delegate;
        this.mountProvider = mountProvider;
    }

    @NotNull
    protected final FileSystemProvider getDelegate() {
        return this.delegate;
    }

    @NotNull
    public MountsAwareFileSystem wrapDelegateFileSystem(@NotNull FileSystem delegateFs) {
        Intrinsics.checkNotNullParameter((Object)delegateFs, (String)"delegateFs");
        return new MountsAwareFileSystem(this, delegateFs);
    }

    @NotNull
    protected FileSystemProvider getDelegate(@Nullable Path path1, @Nullable Path path2) {
        return this.delegate;
    }

    @Nullable
    protected Path wrapDelegatePath(@Nullable Path delegatePath) {
        return delegatePath;
    }

    @Nullable
    protected Path toDelegatePath(@Nullable Path path) {
        return path;
    }

    @Nullable
    public abstract Pair<EelPath, EelFileSystemApi> unwrapEelPath(@NotNull Path var1);

    private final Path getDirectAccessPath(Path path, EelMountRoot.DirectAccessOptions directAccess) {
        if (path == null) {
            return null;
        }
        Pair<EelPath, EelFileSystemApi> pair = this.unwrapEelPath(path);
        if (pair == null) {
            return null;
        }
        Pair<EelPath, EelFileSystemApi> pair2 = pair;
        EelPath eelPath = (EelPath)pair2.component1();
        EelFileSystemApi eelFsApi = (EelFileSystemApi)pair2.component2();
        EelMountRoot eelMountRoot = this.mountProvider.getMountRoot(eelPath);
        if (eelMountRoot == null) {
            return null;
        }
        EelMountRoot mountRoot = eelMountRoot;
        Path directAccessPath = EelNioBridgeServiceKt.asNioPath((EelPath)EelMountProviderKt.transformPath((EelMountRoot)mountRoot, (EelPath)eelPath));
        if (!mountRoot.canReadPermissionsDirectly(eelFsApi, EelProviderUtil.getLocalEel().getFs(), directAccess)) {
            return null;
        }
        return directAccessPath;
    }

    static /* synthetic */ Path getDirectAccessPath$default(MountsAwareFileSystemProvider mountsAwareFileSystemProvider, Path path, EelMountRoot.DirectAccessOptions directAccessOptions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDirectAccessPath");
        }
        if ((n & 2) != 0) {
            directAccessOptions = (EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.BasicAttributes.INSTANCE;
        }
        return mountsAwareFileSystemProvider.getDirectAccessPath(path, directAccessOptions);
    }

    private final <T extends FileAttribute<?>> boolean containsPosixAttribute(T[] $this$containsPosixAttribute) {
        boolean bl;
        block1: {
            T[] $this$any$iv = $this$containsPosixAttribute;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                T element$iv;
                T attr = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                String string = attr.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"posix:", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    protected final <T> T tryUseDirectAccess(@NotNull Path source, @NotNull Path target, @NotNull FileAttribute<?>[] attrs, @NotNull Function2<? super Path, ? super Path, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Path path = this.getDirectAccessPath(source, this.unaryMinus(attrs));
        if (path == null) {
            return null;
        }
        Path sourceDirect = path;
        Path path2 = this.getDirectAccessPath(target, this.unaryMinus(attrs));
        if (path2 == null) {
            return null;
        }
        Path targetDirect = path2;
        try {
            return (T)block.invoke((Object)sourceDirect, (Object)targetDirect);
        }
        catch (IOException e) {
            LOG.debug("Failed to use direct access for " + sourceDirect + " -> " + targetDirect + ", falling back to " + this.delegate, (Throwable)e);
            return null;
        }
    }

    private final EelMountRoot.DirectAccessOptions unaryMinus(FileAttribute<?>[] $this$unaryMinus) {
        Intrinsics.checkNotNullParameter($this$unaryMinus, (String)"<this>");
        return this.containsPosixAttribute($this$unaryMinus) ? (EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.PosixAttributes.INSTANCE : (EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.BasicAttributes.INSTANCE;
    }

    @Nullable
    protected final <T> T tryUseDirectAccess(@NotNull Path $this$tryUseDirectAccess, @NotNull EelMountRoot.DirectAccessOptions directAccess, @NotNull Function1<? super Path, ? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)$this$tryUseDirectAccess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directAccess, (String)"directAccess");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Path path = this.getDirectAccessPath($this$tryUseDirectAccess, directAccess);
        if (path == null) {
            return null;
        }
        Path directPath = path;
        try {
            return (T)block.invoke((Object)directPath);
        }
        catch (IOException e) {
            LOG.debug("Failed to access " + directPath + " directly, falling back to " + this.delegate, (Throwable)e);
            return null;
        }
    }

    public static /* synthetic */ Object tryUseDirectAccess$default(MountsAwareFileSystemProvider mountsAwareFileSystemProvider, Path path, EelMountRoot.DirectAccessOptions directAccessOptions, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tryUseDirectAccess");
        }
        if ((n & 1) != 0) {
            directAccessOptions = (EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.BasicAttributes.INSTANCE;
        }
        return mountsAwareFileSystemProvider.tryUseDirectAccess(path, directAccessOptions, function1);
    }

    @NotNull
    public InputStream newInputStream(@Nullable Path path, OpenOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = path;
        if (object == null || (object = (InputStream)MountsAwareFileSystemProvider.tryUseDirectAccess$default(this, (Path)object, null, arg_0 -> MountsAwareFileSystemProvider.newInputStream$lambda$0(options, arg_0), 1, null)) == null) {
            InputStream inputStream = this.delegate.newInputStream(path, Arrays.copyOf(options, options.length));
            object = inputStream;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        }
        return object;
    }

    @NotNull
    public OutputStream newOutputStream(@Nullable Path path, OpenOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Object object = path;
        if (object == null || (object = (OutputStream)MountsAwareFileSystemProvider.tryUseDirectAccess$default(this, (Path)object, null, arg_0 -> MountsAwareFileSystemProvider.newOutputStream$lambda$0(options, arg_0), 1, null)) == null) {
            OutputStream outputStream = this.delegate.newOutputStream(path, Arrays.copyOf(options, options.length));
            object = outputStream;
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        }
        return object;
    }

    @NotNull
    public SeekableByteChannel newByteChannel(@Nullable Path path, @NotNull Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        Object object = path;
        if (object == null || (object = (SeekableByteChannel)this.tryUseDirectAccess((Path)object, this.unaryMinus(attrs), arg_0 -> MountsAwareFileSystemProvider.newByteChannel$lambda$0(options, attrs, arg_0))) == null) {
            SeekableByteChannel seekableByteChannel = this.delegate.newByteChannel(path, options, Arrays.copyOf(attrs, attrs.length));
            object = seekableByteChannel;
            Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"newByteChannel(...)");
        }
        return object;
    }

    @NotNull
    public FileChannel newFileChannel(@Nullable Path path, @NotNull Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        Object object = path;
        if (object == null || (object = (FileChannel)this.tryUseDirectAccess((Path)object, this.unaryMinus(attrs), arg_0 -> MountsAwareFileSystemProvider.newFileChannel$lambda$0(options, attrs, arg_0))) == null) {
            FileChannel fileChannel = this.delegate.newFileChannel(path, options, Arrays.copyOf(attrs, attrs.length));
            object = fileChannel;
            Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"newFileChannel(...)");
        }
        return object;
    }

    @Nullable
    public AsynchronousFileChannel newAsynchronousFileChannel(@Nullable Path path, @Nullable Set<? extends OpenOption> options, @Nullable ExecutorService executor, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        Object object = path;
        if (object == null || (object = (AsynchronousFileChannel)this.tryUseDirectAccess((Path)object, this.unaryMinus(attrs), arg_0 -> MountsAwareFileSystemProvider.newAsynchronousFileChannel$lambda$0(options, executor, attrs, arg_0))) == null) {
            object = this.delegate.newAsynchronousFileChannel(path, options, executor, Arrays.copyOf(attrs, attrs.length));
        }
        return object;
    }

    public void delete(@Nullable Path path) {
        if (path == null || (Unit)MountsAwareFileSystemProvider.tryUseDirectAccess$default(this, path, null, MountsAwareFileSystemProvider::delete$lambda$0, 1, null) == null) {
            this.delegate.delete(path);
        }
    }

    public void createDirectory(@Nullable Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        Path path = dir;
        if (path == null || (path = (Path)this.tryUseDirectAccess(path, this.unaryMinus(attrs), arg_0 -> MountsAwareFileSystemProvider.createDirectory$lambda$0(attrs, arg_0))) == null) {
            this.delegate.createDirectory(dir, Arrays.copyOf(attrs, attrs.length));
            path = Unit.INSTANCE;
        }
    }

    public boolean deleteIfExists(@Nullable Path path) {
        Comparable<Path> comparable = path;
        return comparable != null && (comparable = (Boolean)MountsAwareFileSystemProvider.tryUseDirectAccess$default(this, (Path)comparable, null, MountsAwareFileSystemProvider::deleteIfExists$lambda$0, 1, null)) != null ? ((Boolean)comparable).booleanValue() : this.delegate.deleteIfExists(path);
    }

    public boolean isSameFile(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        Boolean bl = (Boolean)this.tryUseDirectAccess(path, path2, new FileAttribute[0], MountsAwareFileSystemProvider::isSameFile$lambda$0);
        return bl != null ? bl.booleanValue() : this.delegate.isSameFile(path, path2);
    }

    public void copy(@Nullable Path source, @Nullable Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (source != null && target != null) {
            Path path = (Path)this.tryUseDirectAccess(source, target, new FileAttribute[0], (arg_0, arg_1) -> MountsAwareFileSystemProvider.copy$lambda$0(options, arg_0, arg_1));
            if (path != null) {
                Path it = path;
                boolean bl = false;
                return;
            }
        }
        this.delegate.copy(source, target, Arrays.copyOf(options, options.length));
    }

    public void move(@Nullable Path source, @Nullable Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (source != null && target != null) {
            Path path = (Path)this.tryUseDirectAccess(source, target, new FileAttribute[0], (arg_0, arg_1) -> MountsAwareFileSystemProvider.move$lambda$0(options, arg_0, arg_1));
            if (path != null) {
                Path it = path;
                boolean bl = false;
                return;
            }
        }
        this.delegate.move(source, target, Arrays.copyOf(options, options.length));
    }

    public void createLink(@Nullable Path link, @Nullable Path existing) {
        if (link != null && existing != null) {
            Path path = (Path)this.tryUseDirectAccess(link, existing, new FileAttribute[0], MountsAwareFileSystemProvider::createLink$lambda$0);
            if (path != null) {
                Path it = path;
                boolean bl = false;
                return;
            }
        }
        this.delegate.createLink(link, existing);
    }

    public void createSymbolicLink(@Nullable Path link, @Nullable Path target, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        if (link != null && target != null) {
            Path path = (Path)this.tryUseDirectAccess(link, target, Arrays.copyOf(attrs, attrs.length), MountsAwareFileSystemProvider::createSymbolicLink$lambda$0);
            if (path != null) {
                Path it = path;
                boolean bl = false;
                return;
            }
        }
        this.delegate.createSymbolicLink(link, target, Arrays.copyOf(attrs, attrs.length));
    }

    @Nullable
    public DirectoryStream<Path> newDirectoryStream(@Nullable Path dir, @Nullable DirectoryStream.Filter<? super Path> filter) {
        DirectoryStream<Path> directoryStream;
        Path path;
        block5: {
            block4: {
                path = dir;
                if (path == null) break block4;
                Path p0 = path;
                boolean bl = false;
                Path path2 = MountsAwareFileSystemProvider.getDirectAccessPath$default(this, p0, null, 2, null);
                path = path2;
                if (path2 != null) break block5;
            }
            return this.delegate.newDirectoryStream(dir, filter);
        }
        Path directDir = path;
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(directDir);
            directoryStream = new DirectoryStream<Path>(stream, directDir, dir, filter){
                final /* synthetic */ DirectoryStream<Path> $stream;
                final /* synthetic */ Path $directDir;
                final /* synthetic */ Path $dir;
                final /* synthetic */ DirectoryStream.Filter<? super Path> $filter;
                {
                    this.$stream = $stream;
                    this.$directDir = $directDir;
                    this.$dir = $dir;
                    this.$filter = $filter;
                }

                public Iterator<Path> iterator() {
                    Iterator<Path> iterator2 = this.$stream.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                    Iterator<Path> it = iterator2;
                    return new Iterator<Path>(it, this.$directDir, this.$dir, this.$filter){
                        final /* synthetic */ Iterator<Path> $it;
                        final /* synthetic */ Path $directDir;
                        final /* synthetic */ Path $dir;
                        final /* synthetic */ DirectoryStream.Filter<? super Path> $filter;
                        {
                            this.$it = $it;
                            this.$directDir = $directDir;
                            this.$dir = $dir;
                            this.$filter = $filter;
                        }

                        public boolean hasNext() {
                            return this.$it.hasNext();
                        }

                        public Path next() {
                            Path path;
                            Path next = this.$it.next();
                            String rel = ((Object)this.$directDir.relativize(next)).toString();
                            Path containerPath = this.$dir.resolve(rel);
                            if (this.$filter == null || this.$filter.accept(containerPath)) {
                                Intrinsics.checkNotNull((Object)containerPath);
                                path = containerPath;
                            } else {
                                path = this.next();
                            }
                            return path;
                        }

                        public void remove() {
                            this.$it.remove();
                        }
                    };
                }

                public void close() {
                    this.$stream.close();
                }
            };
        }
        catch (IOException e) {
            LOG.debug("Failed to stream directory at " + directDir + ", falling back to delegate", (Throwable)e);
            directoryStream = this.delegate.newDirectoryStream(dir, filter);
        }
        return directoryStream;
    }

    public void checkAccess(@Nullable Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        if (path == null || (Unit)this.tryUseDirectAccess(path, (EelMountRoot.DirectAccessOptions)EelMountRoot.DirectAccessOptions.PosixAttributesAndAllAccess.INSTANCE, arg_0 -> MountsAwareFileSystemProvider.checkAccess$lambda$0(modes, arg_0)) == null) {
            this.delegate.checkAccess(path, Arrays.copyOf(modes, modes.length));
        }
    }

    @Nullable
    public <A extends BasicFileAttributes> A readAttributes(@Nullable Path path, @NotNull Class<A> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (Intrinsics.areEqual(type, BasicFileAttributes.class)) {
            boolean bl;
            block4: {
                LinkOption[] $this$all$iv = options;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    LinkOption element$iv;
                    LinkOption linkOption = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (linkOption == LinkOption.NOFOLLOW_LINKS) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            if (bl) {
                Object object = path;
                if (object == null || (object = (BasicFileAttributes)MountsAwareFileSystemProvider.tryUseDirectAccess$default(this, (Path)object, null, arg_0 -> MountsAwareFileSystemProvider.readAttributes$lambda$1(type, options, arg_0), 1, null)) == null) {
                    object = this.delegate.readAttributes(path, type, Arrays.copyOf(options, options.length));
                }
                return (A)object;
            }
        }
        return this.delegate.readAttributes(path, type, Arrays.copyOf(options, options.length));
    }

    public boolean isHidden(@Nullable Path path) {
        return this.delegate.isHidden(path);
    }

    @NotNull
    public Path readSymbolicLink(@NotNull Path link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Path path = this.delegate.readSymbolicLink(link);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"readSymbolicLink(...)");
        return path;
    }

    @Nullable
    public <V extends FileAttributeView> V getFileAttributeView(@Nullable Path path, @Nullable Class<V> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.delegate.getFileAttributeView(path, type, Arrays.copyOf(options, options.length));
    }

    @Nullable
    public Map<String, Object> readAttributes(@Nullable Path path, @Nullable String attributes, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.delegate.readAttributes(path, attributes, Arrays.copyOf(options, options.length));
    }

    public void setAttribute(@Nullable Path path, @Nullable String attribute, @Nullable Object value, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.delegate.setAttribute(path, attribute, value, Arrays.copyOf(options, options.length));
    }

    private static final InputStream newInputStream$lambda$0(OpenOption[] $options, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.newInputStream(it, Arrays.copyOf($options, $options.length));
    }

    private static final OutputStream newOutputStream$lambda$0(OpenOption[] $options, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.newOutputStream(it, Arrays.copyOf($options, $options.length));
    }

    private static final SeekableByteChannel newByteChannel$lambda$0(Set $options, FileAttribute[] $attrs, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.newByteChannel(it, $options, Arrays.copyOf($attrs, $attrs.length));
    }

    private static final FileChannel newFileChannel$lambda$0(Set $options, FileAttribute[] $attrs, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FileChannel.open(it, $options, Arrays.copyOf($attrs, $attrs.length));
    }

    private static final AsynchronousFileChannel newAsynchronousFileChannel$lambda$0(Set $options, ExecutorService $executor, FileAttribute[] $attrs, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AsynchronousFileChannel.open(it, $options, $executor, Arrays.copyOf($attrs, $attrs.length));
    }

    private static final Unit delete$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Files.delete(it);
        return Unit.INSTANCE;
    }

    private static final Path createDirectory$lambda$0(FileAttribute[] $attrs, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.createDirectory(it, Arrays.copyOf($attrs, $attrs.length));
    }

    private static final boolean deleteIfExists$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.deleteIfExists(it);
    }

    private static final boolean isSameFile$lambda$0(Path s, Path t) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Files.isSameFile(s, t);
    }

    private static final Path copy$lambda$0(CopyOption[] $options, Path s, Path t) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Files.copy(s, t, Arrays.copyOf($options, $options.length));
    }

    private static final Path move$lambda$0(CopyOption[] $options, Path s, Path t) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Files.move(s, t, Arrays.copyOf($options, $options.length));
    }

    private static final Path createLink$lambda$0(Path s, Path t) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Files.createLink(s, t);
    }

    private static final Path createSymbolicLink$lambda$0(Path s, Path t) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Files.createSymbolicLink(s, t, new FileAttribute[0]);
    }

    private static final Unit checkAccess$lambda$0(AccessMode[] $modes, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.getFileSystem().provider().checkAccess(it, Arrays.copyOf($modes, $modes.length));
        return Unit.INSTANCE;
    }

    private static final BasicFileAttributes readAttributes$lambda$1(Class $type, LinkOption[] $options, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.readAttributes(it, $type, Arrays.copyOf($options, $options.length));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MountsAwareFileSystemProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/eel/impl/fs/MountsAwareFileSystemProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.eel.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

